package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;
import java.util.LinkedList;
import java.io.*;
import com.tildemh.debbuggtk.CommentViewer;

/**
 * Container for displaying bug reports.
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BugReport.java,v 1.10 2002/12/23 16:12:54 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BugReport extends VBox{

	private CommentViewer cv;
	private Label pkg;
	private Label numbr;
	private Label title;
	private Label severity;
	private Label age;
	private Label sync;
	private HBox tags;	
	
	private Bug bug;
	private BTS bts;
	
	
	/**
	 */
	public BugReport(Bug bug, BTS bts){
		super(false, 0);
		this.bts = bts;
		init();
		setBug(bug);
	}
	/**
	 */
	public BugReport(BTS bts){
		super(false, 0);
		this.bts = bts;
		init();
	}

	private void init(){

		HBox hb = new HBox(false, 0);
		packStart(hb, false, true, 0);

		// todo: format first three nicely
		pkg = new Label( "Package" );
		hb.packStart(pkg, true, true, 0);
		
		numbr = new Label( "Bug number" );
		hb.packStart(numbr, true, true, 0);


		// todo: icons, colours?
		severity = new Label( "Severity" );
		hb.packStart(severity, true, true, 0);

		tags = new HBox(false, 3);
		hb.packStart(tags, true, true, 0);
		
		title = new Label( "Title" );
		packStart(title, false, true, 5);
		
		HBox ages = new HBox(false, 0);
		packStart(ages, false, true, 5);

		age = new Label("?? days old");
		ages.packStart(age, true, true, 0);

		sync = new Label("Last checked ??");
		ages.packStart(sync, true, true, 0);

		Button update = new Button(GtkStockItem.REFRESH);
		update.addListener( new ButtonListener(){
			public void buttonEvent(ButtonEvent event){
				if (event.isOfType(ButtonEvent.Type.CLICK)){
					System.out.println("refresh clicked");
					try{
						bug = bts.getBug(bug.getNumber(), true);
					}catch(Exception e){
						System.out.println("OOPS: "+e);
						e.printStackTrace();
						//todo
					}
					setBug(bug);
					System.out.println("Refresh clicked!");
				}
			}
		});
		ages.packStart(update);
		

		cv = new CommentViewer();
		packStart( cv, true, true, 0 );
	}

	public void setBug(Bug bug){
		this.bug = bug;
		System.out.println("Bug report: setting bug to #"+bug.getNumber());
		numbr.setText( (new Integer( bug.getNumber() )).toString() );
		title.setText( bug.getTitle() );
		pkg.setText( bug.getPackageName() );
		sync.setText("Last checked " + bug.getLastUpdated().toLocaleString() );

		severity.setText( bug.getSeverity().toString() );
		LinkedList bugTags = bug.getTags();
		while (bugTags != null && bugTags.size() > 0){
			
			Tag tag = (Tag) bugTags.removeFirst();
			// todo: change to icons
			Label l = new Label(tag.toString());
			tags.packStart(l);
		}
		cv.setBug(bug);

	}
}
