package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;
import java.io.*;

/**
 * Application to give a listing of bugs in a package/src/package/pseudo
 * package/maintainer.
 *
 * <p>{@link com.tildemh.debbuggtk.BugViewer} will be called to display bugs
 * when the user double clicks on them.
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BugLister.java,v 1.6 2002/12/23 15:23:16 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BugLister{
	
	/**
	 * Create a new window
	 */
	public BugLister(Listing list){
		Window window = new Window(WindowType.TOPLEVEL);
		window.setTitle("Debian Package Bug Lister - "+list.getName());
		 window.addListener(new LifeCycleListener() {
			public void lifeCycleEvent(LifeCycleEvent event) {
				if (event.isOfType(LifeCycleEvent.Type.DELETE) || event.isOfType(LifeCycleEvent.Type.DESTROY))
						Gtk.mainQuit();
			}
		});

		VBox vbox = new VBox(false, 0);
		window.add(vbox);

		PkgReport report = new PkgReport(list, listListener);
		ScrolledWindow sw = new ScrolledWindow( new Adjustment(1, 100, 1, 10, 1, 1), new Adjustment(1, 100, 1, 10, 1, 1));
		sw.add(report);
		vbox.packStart(sw, true, true, 0);

		window.showAll();
	}

	PkgReportListener listListener = new PkgReportListener(){
		public void selChanged(com.tildemh.debbug.Bug bug){
			BugViewer bv = new BugViewer(bug);
		}
	};

	public static void main(String[] args) throws Exception{
		Bug bug;
		
		if (args.length==0){
			Gtk.init(args);
//			PkgSelector pkgSel = new PkgSelector();
			Gtk.main();
//			bug = WWWBugParser.downloadBug( pkgSel.get() );
		}else{
			//todo 
		}
			
		Listing list = null;
		File f = new File(args[0]);
		if (f.exists()){
			// load from file
		
			StringBuffer htmlPage = new StringBuffer();
			FileReader reader = new FileReader(args[0]);
			int ch =0;
			while ((ch = reader.read()) != -1){
				htmlPage.append((char)ch);
			}
		
			list = WWWListingParser.makeListing(htmlPage.toString());
		}else{
			// load from web
			list = WWWListingParser.downloadListing(args[0]);
		}

		Gtk.init(args);
		BugLister bl = new BugLister(list);
	    Gtk.main();
	}
}
