package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;

/**
 * Form to select a package to be displayed. This can be any of:
 * <ul>
 * <li>Binary package
 * <li>Source package
 * <li>Maintiner email
 * <li>Submitter email
 * </ul>
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: ListingSelector.java,v 1.15 2003/08/30 17:52:26 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class ListingSelector extends Window implements ButtonListener{
	

	private ListingSelectorHandler handler;

	private Menu menu = new Menu();
	private OptionMenu optionMenu = new OptionMenu();
	private Entry entry = new Entry();
	private Button submit;
	private Button close;
	private Button virtual;
	private CheckButton includeClosed;


	/**
	 * Constructs a pkgselector object
	 * @param handler object which will be called if the dialog sucessfully
	 * exits.
	 */
	public ListingSelector(ListingSelectorHandler handler, boolean showBug){
		super(WindowType.TOPLEVEL);
		this.handler = handler;
		
		setTitle("Download package listings");
		setModal(true);
		setBorderWidth(25);
		
		VBox hbox = new VBox(false, 15);
		add(hbox);

		Label l = new Label("Please select the type and name of a listing to watch. These must exist at bugs.debian.org. Alternatively, click 'Create Custom Listing' to create your own list by supplying bug numers");
		l.setLineWrap(true);
		hbox.packStart(l, false, true, 0);

		HBox hb = new HBox( false, 15);
		hbox.packStart( hb, true, true, 0);

		optionMenu.setMenu( menu );
		// DO not reorder without changing numbers further down!
		menu.append( new MenuItem( "Source Package" , true) );
		menu.append( new MenuItem( "Binary Package" , true) );
		menu.append( new MenuItem( "Pseudo Package" , true) );
		menu.append( new MenuItem( "Maintainer Email" , true) );
		menu.append( new MenuItem( "Submitter Email" , true) );
		menu.append( new MenuItem( "Bug Number" , true) );
	
		optionMenu.setHistory(0);
		HButtonBox hbb = new HButtonBox();
		hbb.add(optionMenu);
		hb.packStart( hbb, false, false, 0);
		
		hb.packStart(entry, true, true, 0);

		submit = new Button( GtkStockItem.ADD );
		HButtonBox bb = new HButtonBox();
		bb.add(submit);
		hb.packStart(bb, false, false, 0);
		submit.addListener( this );

		includeClosed = new CheckButton( "Include _closed (but not archived) reports", true );
		hbox.packStart( includeClosed, true, true, 0);


		hb = new HBox( false, 15);
		hbox.packStart( hb, false, false, 0);
		
		virtual = new Button("Create Custom Listing");
		HButtonBox virtBBox = new HButtonBox();
		virtBBox.setLayout( ButtonBoxStyle.START );
		virtBBox.add(virtual);
		hb.packStart( virtBBox, true, true, 0);
		virtual.addListener( this );

		HButtonBox closeBox = new HButtonBox();
		closeBox.setLayout(ButtonBoxStyle.END);

		close = new Button(GtkStockItem.CANCEL);
		close.addListener( this );
		closeBox.add(close);
		hb.packStart(closeBox);
	}

	public void buttonEvent(ButtonEvent event){
		if (event.isOfType( ButtonEvent.Type.CLICK )){
			if (event.getSource().equals(close)) {
				hide();
			}else if (event.getSource().equals(virtual)){
				hide();
				handler.newVirtual();
			}else if (event.getSource().equals(submit)){
				ListingType type;
				switch (optionMenu.getHistory()){
					case -1: return; 
					case 0: type = ListingType.SOURCE; break;
					case 1: type = ListingType.BINARY; break;
					case 2: type = ListingType.PSEUDO; break;
					case 3: type = ListingType.MAINT; break;
					case 4: type = ListingType.SUBMITTER; break;
					case 5: type = ListingType.BUG; break;
					default: throw new RuntimeException("Unknown optionMenu selection in ListingSelector: "+ optionMenu.getHistory());
				}
				type.setIncludeClosed( includeClosed.getState() );
				handler.listingSelected( entry.getText(), type);
				hide();
			}
		}
	}
}
