package com.tildemh.debbuggtk;

import org.gnu.gnome.*;
import org.gnu.gnome.event.*;

/**
 * Bug reporter page for selecting package
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BRSelectPackage.java,v 1.4 2003/12/07 11:09:46 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BRSelectPackage extends DruidPageStandard implements DruidPageSetupListener, DruidPageChangeListener {

	private boolean contentSet = false;
	private org.gnu.gnome.Entry pkgEntry;
	private BugReporter bugReporter;

	public BRSelectPackage( BugReporter bugReporter ){
		super();
		this.bugReporter = bugReporter;
		addListener( (DruidPageSetupListener) this );
		addListener( (DruidPageChangeListener) this );
		setLogo( BugReporter.getLogo() );
	}


	public void druidPageSetupEvent( DruidPageSetupEvent event ){
		if ( event.isOfType( DruidPageSetupEvent.Type.PREPARE ) ){
			if (!contentSet){
				// make the page
				setTitle("Specify Package");
				pkgEntry = new org.gnu.gnome.Entry("bugreporter-package");
				appendItem("Please specify the name of the Debian package which you want to report a bug against", pkgEntry, "If you do not know the name of a package, try typing <tt>dpkg -s &lt;program-name&gt;</tt> at a command line." );
				// todo: offer list of packages to choose. 
				contentSet = true;
			}
		}
	}

	public boolean druidPageChangeEvent( DruidPageChangeEvent event ){
		if ( event.isOfType( DruidPageChangeEvent.Type.NEXT ) ){
			// todo: make sure package name is valid
			bugReporter.getBug().setPackageName( pkgEntry.getEntry().getText() );
			System.out.println("setting package name to "+ pkgEntry.getEntry().getText());
			return false;
		}else if ( event.isOfType( DruidPageChangeEvent.Type.BACK ) ){
		}else if ( event.isOfType( DruidPageChangeEvent.Type.CANCEL ) ){
		}
		return false;
	}
	
}
