/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * Dns.h
 *   Abstract class for DNS backend.
 *
 * $Id: Dns.h,v 1.7 2001/01/21 19:50:04 rex Exp $
 *
 * Copyright (c) 2000-2001 Remi Lefebvre <remi@step.polymtl.ca>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef DNS_H
#define DNS_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "Logger.h"
#include "Exception.h"
#include "global.h"

#include "DnsRecord.h"

enum DnsRecordType {A, CNAME, NS, MX, ANY};

/**
 * @class Dns
 * @brief Class to make Dynamic Name Server updates.
 */
class Dns
{
  public:
    /// Constructor
    Dns(Logger *log);

    /// Destructor
    virtual ~Dns() { };

    /// Add a DNS record.
    virtual void addDnsRecord(int id, const char *dname, DnsRecordType type,
                              const char *data) = 0;
    /// Remove a DNS record.
    virtual void delDnsRecords(char *dname) = 0;
    virtual void delDnsRecord(int id, const char *dname, DnsRecordType type,
                              const char *data) = 0;

    virtual void updateDnsRecord(int id, const char *dname, DnsRecordType type,
                                 const char *data) = 0;

  protected:
    /// Hidden default constructor
    Dns() { };

  private:
    Logger *log;
};

#endif // DNS_H
