/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * DbMetaData.cc
 *   description goes here
 *
 * $Id: DbMetaData.cc,v 1.4 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Benoit Joly <benoit@ddts.org>
 *                and Remi Lefebvre <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#include "DbMetaData.h"
#include "Exception.h"

/**************************************************************
 * COLUMN POSITION
 *************************************************************/
DbMetaData::ColumnPosition::ColumnPosition()
{
    pos = -1;
}

DbMetaData::ColumnPosition::ColumnPosition(int pos)
{
    this->pos = pos;
}

/**************************************************************
 * COLUMN META DATA
 *************************************************************/
DbMetaData::ColumnMetaData::ColumnMetaData()
{
    this->dataType = UNDEFINED;
}

DbMetaData::ColumnMetaData::ColumnMetaData(const string &name, int size,
                                           DbMetaData::eDataType dataType)
{
    this->name = name;
    this->dataType = dataType;
    this->size = size;
}

DbMetaData::ColumnMetaData::ColumnMetaData(const DbMetaData::ColumnMetaData
                                           &columnMetaData)
{
    this->name = columnMetaData.name;
    this->dataType = columnMetaData.dataType;
    this->size = columnMetaData.size;
}

DbMetaData::ColumnMetaData::~ColumnMetaData()
{
}

/**************************************************************
 * DB META DATA
 *************************************************************/
DbMetaData::DbMetaData()
{
}

DbMetaData::~DbMetaData()
{
}

int DbMetaData::findColumnID(const char *name)
{
    ColumnPosition columnPos = columnNameToPosition[string(name)];
    int pos = columnPos.pos;
    if (pos == -1)
    {
        throw DdtException("findColumnID: no column found");
    }

    return pos;
}

const char *DbMetaData::getColumnName(unsigned int colNo)
{
    if (colNo < metaDataVector.size())
    {
        return NULL;
    }

    return ((ColumnMetaData)metaDataVector[colNo]).name.c_str();
}

DbMetaData::eDataType DbMetaData::getColumnType(unsigned int colNo)
{
    if (colNo < metaDataVector.size())
    {
        return UNDEFINED;
    }
    return ((ColumnMetaData)metaDataVector[colNo]).dataType;
}

int DbMetaData::getColumnSize(unsigned int colNo)
{
    if (colNo < metaDataVector.size())
    {
        return -1;
    }
    return ((ColumnMetaData)metaDataVector[colNo]).size;
}
