<?php
/*
 * $Id: class.htmlWatches.inc.php,v 1.3.2.2.2.4 2003/04/20 01:06:05 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wtch');

class htmlWatches
{
	var $objP;
	var $objJ;
	var $objW;
	var $objT;
	var $objA;

	function htmlWatches()
	{
		$this->objP = CreateObject('dcl.dbProducts');
		$this->objP->Connect();
		$this->objJ = CreateObject('dcl.dbProjects');
		$this->objJ->Connect($this->objP->conn);
		$this->objW = CreateObject('dcl.dbWorkorders');
		$this->objW->Connect($this->objP->conn);
		$this->objT = CreateObject('dcl.dbTickets');
		$this->objT->Connect($this->objP->conn);
		$this->objA = CreateObject('dcl.dbAccounts');
		$this->objA->Connect($this->objP->conn);
	}

	function createCombo($default = 1)
	{
		echo $this->GetCombo($default);
	}

	function GetCombo($default = 1)
	{
		$obj = CreateObject('dcl.dbWatches');

		$retVal = '<select name="actions">';
		while (list($key, $val) = each($obj->arrActions))
		{
			$retVal .= "<option value=\"$key\"";
			if ($key == $default)
				$retVal .= ' selected';
			$retVal .= ">$val</option>";
		}

		$retVal .= '</select>';

		return $retVal;
	}

	function GetObjectDescription($type, $key1, $key2 = 0)
	{
		switch($type)
		{
			case 1:
			case 4:
				$this->objP->Load($key1);
				return $this->objP->name;
			case 2:
				$this->objJ->Load($key1);
				return '(' . $key1 . ') ' . $this->objJ->name;
			case 3:
				if ($key2 > 0)
				{
					$this->objW->Load($key1, $key2);
					return '(' . $key1 . '-' . $key2 . ') ' . $this->objW->summary;
				}

				return '(' . $key1 . ') ' . STR_WTCH_ALLSEQ;
			case 5:
				$this->objT->Load($key1);
				return '(' . $key1 . ') ' . $this->objT->summary;
			case 6:
			case 7:
				$this->objA->Load($key1);
				return $this->objA->name;
		}

		return STR_WTCH_INVALIDITEM;
	}

	function PrintMine()
	{
		$obj = CreateObject('dcl.dbWatches');
		$obj->Connect();

		$obj->Query(sprintf('SELECT * FROM watches WHERE whoid=%d ORDER BY typeid,watchid', $GLOBALS['DCLID']));
		$bGotSome = true;
		if (!$obj->next_record())
		{
			$bGotSome = false;
			echo '<center>';
			print(STR_WTCH_YOUHAVENONE);
			echo '</center>';
			return;
		}

		$prevType = 0;

		$t = CreateTemplate(array('hForm' => 'htmlWatches.tpl'));
		$t->set_block('hForm', 'grouping', 'hGrouping');
		$t->set_block('hForm', 'watches', 'hWatches');
		$t->set_var('hGrouping', '');
		$t->set_var('hWatches', '');

		$t->set_var('TXT_TITLE', STR_WTCH_MYWTCH);
		$t->set_var('TXT_SUMMARY', STR_WTCH_SUMMARY);
		$t->set_var('TXT_ACTIONS', STR_WTCH_ACTIONS);
		$t->set_var('TXT_OPTIONS', STR_WTCH_OPTIONS);

		do // next_record already called
		{
			$obj->GetRow();
			if ($obj->typeid != $prevType)
			{
				$iRow = 0;
				$t->set_var('VAL_GROUP', $obj->arrTypeid[$obj->typeid]);
				$t->set_var('HDR_GROUP', $t->parse('hGrouping', 'grouping'));

				$prevType = $obj->typeid;
			}
			else
			{
				$t->set_var('HDR_GROUP', '');
				$iRow++;
			}

			if ($iRow % 2 == 0)
				$t->set_var('COLOR_ROW', '#ffffff');
			else
				$t->set_var('COLOR_ROW', $GLOBALS['dcl_info']['DCL_COLOR_LIGHT']);

			list($summary, $link) = each($this->GetMyViewLinkAndDescription($obj));

			$t->set_var('VAL_SUMMARY', $summary);
			$t->set_var('VAL_ACTIONS', $obj->arrActions[$obj->actions]);

			$options = sprintf('<a class="adark" href="%s">%s</a>', $link, STR_CMMN_VIEW);
			$options .= '&nbsp;|&nbsp;';
			$options .= sprintf('<a class="adark" href="%s">%s</a>', menuLink('', 'menuAction=boWatches.modify&watchid=' . $obj->watchid), STR_CMMN_EDIT);
			$options .= '&nbsp;|&nbsp;';
			$options .= sprintf('<a class="adark" href="%s">%s</a>', menuLink('', 'menuAction=boWatches.delete&watchid=' . $obj->watchid), STR_CMMN_DELETE);
			
			$t->set_var('VAL_OPTIONS', $options);

			$t->parse('hWatches', 'watches', true);
		}
		while ($obj->next_record());
		
		$t->set_var('hGrouping', '');
		$t->pparse('out', 'hForm');
	}

	function ShowEntryForm($obj = '', $desc = '')
	{
		global $dcl_info;

		$isEdit = is_object($obj);

		$Template = CreateTemplate(array('hForm' => 'htmlWatchForm.tpl'));
		$Template->set_var('hEdit', '');
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_ACTIONS', STR_WTCH_ACTIONS);
		$Template->set_var('VAL_FORMACTION', menuLink(''));
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_CMMN_HIGHLIGHTEDNOTE);

		if ($isEdit)
		{
			$Template->set_var('TXT_TITLE', sprintf(STR_WTCH_EDIT, $obj->arrTypeid[$obj->typeid]));
			$Template->set_var('VAL_DESC', $this->GetObjectDescription($obj->typeid, $obj->whatid1, $obj->whatid2));
			$Template->set_var('VAL_TYPEID', $obj->typeid);
			$Template->set_var('VAL_WHATID1', $obj->whatid1);
			$Template->set_var('VAL_WHATID2', $obj->whatid2);
			$Template->set_var('VAL_WHOID', $obj->whoid);
			$Template->set_var('CMB_ACTIONS', $this->GetCombo($obj->actions));

			$hiddenvars = '<input type="hidden" name="menuAction" value="boWatches.dbmodify">';
			$hiddenvars .= sprintf('<input type="hidden" name="watchid" value="%d">', $obj->watchid);
		}
		else
		{
			$objW = CreateObject('dcl.dbWatches');
			$Template->set_var('TXT_TITLE', sprintf(STR_WTCH_ADD, $objW->arrTypeid[$GLOBALS['typeid']]));
			$Template->set_var('VAL_DESC', $this->GetObjectDescription($GLOBALS['typeid'], $GLOBALS['whatid1'], IsSet($GLOBALS['whatid2']) ? $GLOBALS['whatid2'] : 0));
			$Template->set_var('VAL_TYPEID', $GLOBALS['typeid']);
			$Template->set_var('VAL_WHATID1', $GLOBALS['whatid1']);
			$Template->set_var('VAL_WHOID', $GLOBALS['DCLID']);
			$Template->set_var('CMB_ACTIONS', $this->GetCombo());

			if (IsSet($GLOBALS['whatid2']))
				$Template->set_var('VAL_WHATID2', $GLOBALS['whatid2']);
			else
				$Template->set_var('VAL_WHATID2', 0);

			$hiddenvars = '<input type="hidden" name="menuAction" value="boWatches.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hiddenvars);

		$Template->pparse('out', 'hForm');
	}

	function GetMyViewLinkAndDescription($obj)
	{
		$summary = $this->GetObjectDescription($obj->typeid, $obj->whatid1, $obj->whatid2);
		$link = '';
		switch ($obj->typeid)
		{
			case 1:
			case 4:
				if ($obj->typeid == 1)
					$which = 'workorders';
				else
					$which = 'tickets';

				$link = menuLink('','menuAction=boProducts.view&id=' . $obj->whatid1. '&which=' .$which);

				break;
			case 2:
				$link = menuLink('', 'menuAction=boProjects.viewproject&project=' . $obj->whatid1);
				break;
			case 3:
				if ($obj->whatid2 > 0)
					$link = menuLink('', 'menuAction=boWorkorders.viewjcn&jcn=' . $obj->whatid1 . '&seq=' . $obj->whatid2);
				else
					$link = menuLink('', 'menuAction=boWorkorders.viewjcn&jcn=' . $obj->whatid1);

				break;
			case 5:
				$link = menuLink('', 'menuAction=boTickets.view&ticketid=' . $obj->whatid1);
				break;
			case 6:
			case 7:
				$link = menuLink('', 'menuAction=htmlAccounts.view&id=' . $obj->whatid1);
				break;
			default:
				$summary = STR_WTCH_INVALIDITEM;
				break;
		}

		return array($summary => $link);
	}

	function my($rowlimit = 5)
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbWatches');
		$obj->Connect();

		$query = sprintf('SELECT * FROM watches WHERE whoid=%d ORDER BY typeid,watchid ', $GLOBALS['DCLID']);

		$obj->LimitQuery($query, 0, $rowlimit);

		$t = CreateTemplate(array('hForm' => 'htmlMy.tpl'));
		$t->set_block('hForm', 'row', 'hRow');
		$t->set_block('hForm', 'nothing', 'hNothing');
		$t->set_var('hRow', '');
		$t->set_var('hNothing', '');

		$t->set_var('TXT_TITLE', STR_WTCH_MYWTCH);
		$t->set_var('TXT_TOP', sprintf(STR_CMMN_TOPNUM, $rowlimit));
		$t->set_var('LNK_MY', menuLink('', 'menuAction=boWatches.showall'));

		if ($obj->next_record())
		{
			$i = 0;
			do
			{
				$obj->GetRow();
				list($summary, $link) = each($this->GetMyViewLinkAndDescription($obj));

				if ($link != '')
				{
					$t->set_var('COLOR_ROW', ($i++ % 2 == 0 ? '#cecece' : $dcl_info['DCL_COLOR_LIGHT']));
					$t->set_var('LNK_ROW', $link);
					$t->set_var('VAL_ROW', $obj->arrTypeid[$obj->typeid] . ': ' . $summary);
					$t->parse('hRow', 'row', true);
				}
			}
			while ($obj->next_record());
		}
		else
		{
			$t->set_var('TXT_NOTHING', STR_WTCH_YOUHAVENONE);
			$t->parse('hNothing', 'nothing');
		}

		$t->pparse('out', 'hForm');
	}
}
?>
