<?php
/*
 * $Id: oracle8.php,v 1.1.2.3.2.2 2002/11/01 13:51:38 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

if (!IsSet($GLOBALS['ORACLE8_PHP_INCLUDED']))
{
	$GLOBALS['ORACLE8_PHP_INCLUDED'] = 1;

	include ('datetime.php');

	class dclDB
	{
		var $conn;
		var $res;
		var $oid;
		var $cur;
		var $fieldArray;
		var $foreignKeys;
		var $cache;
		var $cacheEnabled;
		var $schemaVersion = '3';
		var $objTimestamp;
		var $objDate;
		var $emptyTimestamp;
		var $Record;

		function dclDB()
		{
			$this->conn = 0;
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;

			$this->objTimestamp = new DCLTimestamp;
			$this->objDate = new DCLDate;

			$this->emptyTimestamp = 'null';
			$this->Record = array();
		}

		function ReportError($res = null, $retVal = -1)
		{
			$a = OCIError($res);
			if ($a)
				printf('OCI Error %d: %s', $a['code'], $a['message']);

			return $retVal;
		}

		function Connect($conn = '')
		{
			global $dcl_domain_info, $dcl_domain;

			if (conn == "")
			{
				if (!IsSet($GLOBALS['__DB_CONN__']))
				{
					$user = $dcl_domain_info[$dcl_domain]['dbUser'] . '@' . $dcl_domain_info[$dcl_domain]['dbHost'];
					$this->conn = OCILogon($user, $dcl_domain_info[$dcl_domain]['dbPassword'], $dcl_domain_info[$dcl_domain]['dbName']);
					if ($this->conn)
						$this->Execute("alter session set NLS_DATE_FORMAT='YYYY-MM-DD 24HH:MI:SS'");
				}
				else
					$this->conn = $conn;

				if (!$this->conn)
					return $this->ReportError(null, 0);

				return $this->conn;
			}
		}

		function Query($query)
		{
			$this->FreeResult();
			$this->oid = 0;
			$this->cur = -1;
			$this->vcur = -1;
			$this->Record = array();

			if ($this->conn)
			{
				if (!($this->res = OCIParse($this->conn, $query)))
				{
					print("<br>Error parsing query!<br>$query<br>");
					return $this->ReportError($this->conn);
				}

				if (OCIExecute($this->res))
				{
					$this->cur = 0;
					return $this->res;
				}
				else
				{
					print("<br>Error executing query!<br>$query<br>");
					return $this->ReportError($this->res);
				}
			}
			else
				return -1;
		}

		function LimitQuery($query, $offset, $rows)
		{
			$this->FreeResult();
			$this->oid = 0;
			$this->cur = -1;
			$this->vcur = -1;
			$this->Record = array();

			if ($this->conn)
			{
				if (!($this->res = OCIParse($this->conn, $query)))
				{
					print("<br>Error parsing query!<br>$query<br>");
					return $this->ReportError($this->conn);
				}

				if (OCIExecute($this->res))
				{
					$this->cur = 0;
					// Push cursor to appropriate row in case next_record() is used
					while ($this->cur < $offset)
					{
						OCIFetch($this->res);
						$this->cur++;
					}

					$this->vcur = $offset + $rows - 1;

					return $this->res;
				}
				else
				{
					print("<br>Error executing query!<br>$query<br>");
					return -1;
				}
			}
			else
				return -1;
		}

		function Execute($query)
		{
			return $this->Query($query);
		}

		function Insert($query)
		{
			return $this->Query($query);
		}

		function FreeResult()
		{
			$this->Record = array();
			if ($this->res != 0)
				@OCIFreeStatement($this->res);

			$this->res = 0;
		}

		function BeginTransaction()
		{
			return $this->Execute('BEGIN');
		}

		function EndTransaction()
		{
			return $this->Execute('COMMIT');
		}

		function RollbackTransaction()
		{
			return $this->Execute('ROLLBACK');
		}

		function NumRows()
		{
			return -1; // No OCI function - time to snip this puppy?
		}

		function NumFields()
		{
			if ($this->res)
				return OCINumCols($this->res);
			else
				return -1;
		}

		// from phpGW/phpLib db classes - sort of
		function next_record()
		{
			// bump up if just ran query
			if ($this->cur == -1)
				$this->cur = 0;

			@OCIFetchInto($this->res, $this->Record, OCI_NUM | OCI_ASSOC | OCI_RETURN_NULLS);

			$stat = is_array($this->Record);
			if ($stat)
			{
				// need to lowercase all field names - reset upper case name, set as lower case
				for ($i = 0; $i < OCINumCols($this->res); $i++)
				{
					$k = OCIColumnName($this->res, $i);
					$v = $this->Record[$i];
					unset($this->Record[$k]);
					$this->Record[strtolower($k)] = $v;
				}
			}
			else
				$this->FreeResult();

			return $stat;
		}

		// from phpGW/phpLib db classes - sort of
		function f($sName)
		{
			return $this->Record[$sName];
		}

		function GetFieldName($fieldIndex)
		{
			if ($this->res)
				return strtolower(OCIColumnName($this->res, $fieldIndex));

			return '';
		}

		function IsFieldNull($thisField)
		{
			if ($this->res)
			{
				if (count($this->Record) > 0)
					return $this->Record[$thisField] == NULL;

				return OCIColumnIsNULL($this->res, $this->cur, $thisField);
			}
			else
				return -1;
		}

		function FetchAllRows()
		{
			$retVal = array();
			$i = 0;
			// bump up if just ran query
			if ($this->cur == -1)
				$this->cur = 0;

			while (@OCIFetchInto($this->res, $a, OCI_NUM | OCI_RETURN_NULLS))
				$retVal[$i++] = $a;

			return $retVal;
		}

		function InitFromArray($aSource)
		{
			reset($this->fieldArray);
			while (list($key, $field) = each($this->fieldArray))
			{
				if (IsSet($aSource[$field]))
					$this->$field = $aSource[$field];
			}
		}

		function InitFromGlobals()
		{
			reset($this->fieldArray);
			while (list($key, $field) = each($this->fieldArray))
			{
				if (IsSet($GLOBALS[$field]))
				{
					$this->$field = $this->GPCStripSlashes($GLOBALS[$field]);
				}
			}
		}

		function DBAddSlashes($thisString)
		{
			if (!IsSet($thisString) || $thisString == '')
				return '';

			return AddSlashes($thisString);
		}

		function GPCStripSlashes($thisString)
		{
			if (get_magic_quotes_gpc() == 0)
				return $thisString;

			return stripslashes($thisString);
		}

		function CacheRow($key)
		{
			if (!$this->cacheEnabled || IsSet($this->cache[$key]))
				return -1;

			reset($this->fieldArray);
			while (list($dummykey, $field) = each($this->fieldArray))
			{
				if (IsSet($this->$field))
					$this->cache[$key][$field] = $this->$field;
			}

			return 0;
		}

		function LoadCache($key)
		{
			if (!$this->cacheEnabled || !IsSet($this->cache[$key]))
				return -1;

			reset($this->fieldArray);
			while (list($dummykey, $field) = each($this->fieldArray))
			{
				if (IsSet($this->cache[$key][$field]))
					$this->$field = $this->cache[$key][$field];
			}

			return 0;
		}

		function GetNewIDSQLForTable($tableName)
		{
			$seqName = '';
			switch($tableName)
			{
				case 'severities':
					$seqName = 'seq_severity';
				case 'workorders':
					$seqName = 'seq_jcn';
				case 'dcl_projects':
					$seqName = 'seq_projects';
				default:
					$seqName = "seq_$tableName";
			}

			if ($this->Query('select ' . $seqName . '.nextval from dual') != -1)
			{
				if ($this->next_record())
				{
					// Save the ID here in case we need it later since
					// there's no good way to get this ID later for this
					// particular connection
					$this->oid = $this->f(0);
					return $this->f(0);
				}
			}

			return '';
		}

		function GetSeqSQL($jcn)
		{
			if ($this->Query('select next_seq(' . $jcn . ') from dual') != -1)
			{
				if ($this->next_record())
				{
					// Save the ID here in case we need it later since
					// there's no good way to get this ID later for this
					// particular connection
					$this->oid = $this->f(0);
					return $this->f(0);
				}
			}

			return '';
		}

		function GetDateSQL()
		{
			return 'sysdate';
		}

		function DisplayToSQL($thisDate)
		{
			global $dcl_info;

			$eregStr = str_replace('m', '([0-9]{2})', $dcl_info['DCL_DATE_FORMAT']);
			$eregStr = str_replace('d', '([0-9]{2})', $eregStr);
			$eregStr = str_replace('Y', '([0-9]{4})', $eregStr);
			if(ereg('^' . $eregStr . ' ([0-9]{2}).([0-9]{2}).([0-9]{2})$', $thisDate))
				return "to_date('" . $this->ArrangeTimeStampForInsert($thisDate) . "', 'YYYY-MM-DD 24HH:MI:SS')";
			else
				return "to_date('" . $this->ArrangeDateForInsert($thisDate) . "', 'YYYY-MM-DD')";
		}

		function ArrangeDateForInsert($thisDate)
		{
			$this->objDate->SetFromDisplay($thisDate);
			return $this->objDate->ToDB();
		}

		function ArrangeTimeStampForInsert($thisStamp)
		{
			global $dcl_domain_info, $dcl_domain;

			$this->objTimestamp->SetFromDisplay($thisStamp);
			return $this->objTimestamp->ToDB();
		}

		function FormatDateForDisplay($thisDate)
		{
			if ($thisDate == '')
				return '';

			$this->objDate->SetFromDB($thisDate);
			return $this->objDate->ToDisplay();
		}

		function FormatTimeStampForDisplay($thisStamp)
		{
			global $dcl_domain_info, $dcl_domain;

			if ($thisStamp == '')
				return '';

			$this->objTimestamp->SetFromDB($thisStamp);
			return $this->objTimestamp->ToDisplay();
		}

		function GetUpperSQL($text)
		{
			return sprintf('upper(%s)', $text);
		}

		function GetLastInsertID($sTable)
		{
			if (!($res = OCIParse($this->conn, "select currval(seq_$sTable)")))
			{
				print("<br>Error parsing insert ID query!");
				return $this->ReportError($this->conn);
			}

			if (OCIExecute($res))
			{
				@OCIFetchInto($res, $Record, OCI_NUM | OCI_ASSOC | OCI_RETURN_NULLS);
				@OCIFreeStatement($res);
				return $Record[0];
			}

			print("<br>Error executing insert ID query!");
			return $this->ReportError($res);
		}

		function HasFKRef($id)
		{
			$bHasRef = false;
			$oKey = new dclDB; // Don't really need anything fancy, 'spose...
			while ((list($sTable, $sField) = each($this->foreignKeys)) && !$bHasRef)
			{
				if (is_array($sField)) // More than one field in here references this key
				{
					while ((list($sDummyKey, $sOneField) = each($sField)) && !$bHasRef)
					{
						$oKey->Query("SELECT $sOneField FROM $sTable WHERE $sOneField=$id");
						if ($oKey->next_record())
							$bHasRef = true;
					}
				}
				else
				{
					$oKey->Query("SELECT $sField FROM $sTable WHERE $sField=$id");
					if ($oKey->next_record())
						$bHasRef = true;
				}
			}

			return $bHasRef;
		}
	}
}
?>
