<?php
/*
 * $Id: class.htmlAccounts.inc.php,v 1.2.2.2 2002/02/15 07:06:27 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('acct');

class htmlAccounts
{
	function createCombo($default = 0, $cbName = 'account', $longShort = 'name', $size = 0, $activeOnly = true)
	{
		print $this->GetCombo($default, $cbName, $longShort, $size, $activeOnly);
	}

	function GetCombo($default = 0, $cbName = 'account', $longShort = 'name', $size = 0, $activeOnly = true)
	{
		$obj = CreateObject('dcl.dbAccounts');
		$obj->Connect();
		$obj->cacheEnabled = false;

		$query = "SELECT id,$longShort FROM accounts WHERE id>0";

		if ($activeOnly)
			$query .= ' AND active=\'Y\' ';

		$query .= " ORDER BY $longShort";
		$obj->Query($query);

		$str = '<select name="' . $cbName;
		if ($size > 0)
			$str .= '[]" multiple size="' . $size . '"';
		else
			$str .= '"';
		$str .= '>';
		if ($size == 0)
			$str .= '<option value="0">' . STR_ACCT_SELECTONE;

		while ($obj->next_record())
		{
			$id = $obj->f(0);
			$str .= '<option value="'. $id . '"';
			if ($id == $default)
				$str .= ' selected';
			$str .= '>';
			$str .= $obj->f(1);
		}

		$str .= '</select>';

		return $str;
	}

	function ShowSearchForm()
	{
		global $dcl_info;

		$Template = CreateTemplate(array('hForm' => 'htmlAccountsSearch.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		// Labels
		$Template->set_var('TXT_ACCOUNTSEARCH', STR_ACCT_ACCOUNTSEARCH);
		$Template->set_var('TXT_SEARCHTEXT', STR_ACCT_SEARCHTEXT);
		$Template->set_var('TXT_NAME', STR_ACCT_NAME);
		$Template->set_var('TXT_SHORTNAME', STR_ACCT_SHORT);
		$Template->set_var('TXT_CITY', STR_ACCT_CITY);
		$Template->set_var('BTN_SEARCH', STR_CMMN_SEARCH);

		$Template->pparse('out', 'hForm');
	}

	function ExecuteSearch($searchFld, $searchText)
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbAccounts');
		$obj->Connect();

		$query = 'SELECT id,active,name,add1,add2,city,state,zip,contact,voice,fax,data1,data2 FROM accounts';
		if ($searchText != '')
			$query .= ' WHERE ' . $obj->GetUpperSQL($searchFld) . ' LIKE \'%' . strtoupper($searchText) . '%\'';
		$query .= ' ORDER BY ' . $obj->GetUpperSQL($searchFld);

		$obj->Query($query);
		$allRecs = $obj->FetchAllRows();
		if (count($allRecs) > 0)
		{
			// Format the phone numbers
			for ($i = 0; $i < count($allRecs); $i++)
				for ($j = 9; $j < 13; $j++)
					$allRecs[$i][$j] = FormatPhone($allRecs[$i][$j]);

			$allName = array(
					0 => STR_ACCT_ID, 
					1  => STR_ACCT_ACTIVEABB, 
					2  => STR_ACCT_NAME, 
					3  => STR_ACCT_ADDRESS1, 
					4  => STR_ACCT_ADDRESS2, 
					5  => STR_ACCT_CITY,
					6  => STR_ACCT_STATEABB, 
					7  => STR_ACCT_ZIP, 
					8  => STR_ACCT_CONTACT, 
					9  => STR_ACCT_CONTACTPH,
					10 => STR_ACCT_FAX, 
					11 => STR_ACCT_DATA1, 
					12 => STR_ACCT_DATA2);

			if (count($allRecs) > 0)
			{
				$allName[] = STR_ACCT_OPTIONS;
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="' . menuLink('', 'menuAction=boWatches.add&typeid=6&whatid1=' . $allRecs[$i][0]) . '">' . STR_ACCT_WATCHWO . '</a>';
					$options .= '&nbsp;|&nbsp;';
					$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boWatches.add&typeid=7&whatid1=' . $allRecs[$i][0]) . '">' . STR_ACCT_WATCHTCK . '</a>';
					if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
					{
						$options .= '|&nbsp;';
						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boAccounts.modify&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_EDIT . '</a>';
						$options .= '&nbsp;|&nbsp;';
						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boAccounts.delete&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_DELETE . '</a>';
					}
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, sprintf(STR_ACCT_TABLETITLE, $searchFld, $searchText));
		}
		else
		{
			print('<CENTER>');
			PrintWithChocoFont(sprintf(STR_ACCT_NOTFOUND, $searchFld, $searchText));
			print('</CENTER>');
		}
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlAccountsForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$hidden_vars = '';
		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', STR_ACCT_EDITACCOUNT);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boAccounts.dbmodify">';
			$hidden_vars .= '<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', STR_ACCT_ADDNEWACCOUNT);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boAccounts.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

		// Labels
		$Template->set_var('TXT_ACTIVE', STR_ACCT_ACTIVE);
		$Template->set_var('TXT_SHORT', STR_ACCT_SHORT);
		$Template->set_var('TXT_NAME', STR_ACCT_NAME);
		$Template->set_var('TXT_ADDRESS1', STR_ACCT_ADDRESS1);
		$Template->set_var('TXT_ADDRESS2', STR_ACCT_ADDRESS2);
		$Template->set_var('TXT_CITY', STR_ACCT_CITY);
		$Template->set_var('TXT_STATE', STR_ACCT_STATE);
		$Template->set_var('TXT_ZIP', STR_ACCT_ZIP);
		$Template->set_var('TXT_CONTACT', STR_ACCT_CONTACT);
		$Template->set_var('TXT_CONTACTPH', STR_ACCT_CONTACTPH);
		$Template->set_var('TXT_FAX', STR_ACCT_FAX);
		$Template->set_var('TXT_DATA1', STR_ACCT_DATA1);
		$Template->set_var('TXT_DATA2', STR_ACCT_DATA2);
		$Template->set_var('TXT_NOTES', STR_ACCT_NOTES);
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_ACCT_HIGHLIGHTEDNOTE);

		// Data
		if ($isEdit)
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_SHORT', $obj->short);
			$Template->set_var('VAL_NAME', $obj->name);
			$Template->set_var('VAL_ADD1', $obj->add1);
			$Template->set_var('VAL_ADD2', $obj->add2);
			$Template->set_var('VAL_CITY', $obj->city);
			$Template->set_var('VAL_STATE', $obj->state);
			$Template->set_var('VAL_ZIP', $obj->zip);
			$Template->set_var('VAL_CONTACT', $obj->contact);
			$Template->set_var('VAL_VOICE', $obj->voice);
			$Template->set_var('VAL_FAX', $obj->fax);
			$Template->set_var('VAL_DATA1', $obj->data1);
			$Template->set_var('VAL_DATA2', $obj->data2);
			$Template->set_var('VAL_NOTES', $obj->notes);
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_NAME', '');
			$Template->set_var('VAL_ADD1', '');
			$Template->set_var('VAL_ADD2', '');
			$Template->set_var('VAL_CITY', '');
			$Template->set_var('VAL_STATE', '');
			$Template->set_var('VAL_ZIP', '');
			$Template->set_var('VAL_CONTACT', '');
			$Template->set_var('VAL_VOICE', '');
			$Template->set_var('VAL_FAX', '');
			$Template->set_var('VAL_DATA1', '');
			$Template->set_var('VAL_DATA2', '');
			$Template->set_var('VAL_NOTES', '');
		}

		$Template->pparse('out', 'hForm');
	}

	function ShowDetail($obj)
	{
		if (!is_object($obj))
		{
               // Hmmm...need account object
			print('<BR>' . STR_ACCT_NOOBJECTERR . '<BR>');
			return;
		}

		printf('<BR>%s: %s', STR_ACCT_NAME, $obj->name);
	}
}
?>
