/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 * 
 * my_poll.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: my_poll.h,v 2.0 2003/01/30 12:50:45 eric Exp $
*/

#ifndef __MY_POLL_H__
#define __MY_POLL_H__

/* code taken from poll manual */
struct pollfd
{
                int fd;           /* file descriptor */
                short events;     /* requested events */
                short revents;    /* returned events */
};

/* the code does not support all poll flags */
#define POLLIN      0x0001    /* There is data to read */
#define POLLPRI     0x0002    /* There is urgent data to read */
#define POLLOUT     0x0004    /* Writing now will not block */
#define POLLERR     0x0008    /* Error condition */

int poll(struct pollfd *ufds, unsigned int nfds, int timeout);

#endif
