/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * multi_private_chat_cmd.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: multi_public_chat_cmd.h,v 2.0 2003/02/05 18:12:37 eric Exp $
*/

#ifndef __MULTI_PUBLIC_CHAT_CMD_H__
#define __MULTI_PUBLIC_CHAT_CMD_H__

#include "user_cnx_lst.h"

/***********************************/
/* functions available for hub_cmd */
/***********************************/

/*****************************/
/* use to join a public chat */
/*****************************/
int cmd_join_public_chat(const char *cmd, LOCAL_USER_CNX_ENTRY *ptr, GString **dest_base,
               const GString *str, char *xtra_param, const GPtrArray *splitted_str);

/***************************************/
/* list all chats available on the hub */
/***************************************/
int cmd_list_public_chat(const char *cmd, LOCAL_USER_CNX_ENTRY *ptr, GString **dest_base,
               const GString *str, char *xtra_param, const GPtrArray *splitted_str);

/***********************/
/* leave a public chat */
/***********************/
int cmd_leave_public_chat(const char *cmd, LOCAL_USER_CNX_ENTRY *ptr, GString **dest_base,
               const GString *str, char *xtra_param, const GPtrArray *splitted_str);

/****************************/
/* create a new public chat */
/****************************/
int cmd_create_public_chat(const char *cmd, LOCAL_USER_CNX_ENTRY *luce, GString **dest_base,
               const GString *str, char *xtra_param, const GPtrArray *splitted_str);

#endif /* ! __MULTI_PUBLIC_CHAT_H__ */
