/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * main.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: main.h,v 2.0 2003/01/30 12:50:45 eric Exp $
*/

#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "macro.h"

extern GString *hubname;
extern char *site_root;
extern unsigned short hub_port;
extern char  *gl_bind_addr;

#ifndef HAVE_INET_ATON
int	inet_aton(const char *cp, struct in_addr * addr);
#endif
/*******************************************************/
/* add an external program to start by the main thread */
/*******************************************************/
void	add_prog_to_start(char *progname);
void	init_python(void);
int	load_dyn_conf(void);

/***************************************************************/
/* change the user ID of the process if a different one is set */
/***************************************************************/
void set_user_id(void);

/*******************************************/
/* there is some bug using %Lu with cygwin */
/*******************************************/

#ifdef __CYGWIN__
void    str_to_llunsigned(char  *str, long long unsigned *lu);
char    *llunsigned_to_str(long long unsigned a);
#endif

#endif
