/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * hub_cnx_handshake.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: hub_cnx_handshake.h,v 2.4 2003/02/11 17:59:16 eric Exp $
*/

#ifndef __HUB_CNX_HANDSHAKE_H__
#define __HUB_CNX_HANDSHAKE_H__

#include "bin_xf_io.h"
#include "chunk_codes.h"
#include "common_defines.h"

#define MAX_HUB_HANDSHAKE_TIME 9

typedef enum
{
	STEP_ID_SENT=0,
	STEP_CHALLENGE_SENT,
	STEP_LOG_CHECK,
	STEP_LOG_DONE,
} HUB_LOG_STEP;

typedef struct
{
	BIN_XF_IO *bxfio;	/* I/O to monitor */
	guint8 remote_hub_id[HUB_ID_LEN];
	guint8 varykey[MD_BLOC_SIZE];		/* used in combination with remote hub_id and cluster_id to build a challenge */
	guint8 used_clus_id[MD_BLOC_SIZE];
	guint8 wanted_md_result[MD_BLOC_SIZE];		/* MD5 of combination of (remote_hub_id.varykey.used_clus_id) */
	HUB_LOG_STEP log_step;

	/* final stage info */
	char *f_hub_name;
	HUB_CNX_TYPE f_hc_type;
	guint32 f_hop_cost;
} HUB_HSHAKE;

/****************************************************/
/* register a new socket into the handshake handler */
/****************************************************/
/* if remote_addr ==NULL, the function computes it */
/***************************************************/
void hub_handshake_register_new_fd(int sock_fd, struct in_addr *remote_addr);

/***********************************************/
/* function initializing the handshake handler */
/***********************************************/
GED_CALLBACKS *hub_handshake_init(void);
#endif
