/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * hub_cnx.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: hub_cnx.c,v 2.3 2003/05/19 17:02:23 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#ifdef HAVE_SYS_POLL_H
#include <sys/poll.h>
#else
#include "my_poll.h"
#endif

#ifdef WIN32
	#include <windows.h>
	#include <winsock2.h>
#else
	#include <sys/types.h>
	#include <sys/socket.h>
#endif

#include <glib.h>

#include "config.h"
#include "main.h"

#include "ged_if.h"
#include "network.h"
#include "timed_out_string.h"
#include "tos_key.h"
#include "gvar.h"
#include "hub_cnx_handshake.h"

/* ************************************************************************** */
/* ************************************************************************** */
/* ************************************************************************** */
/* ******************* connection acceptation handler *********************** */
/* ************************************************************************** */
/* ************************************************************************** */
/* ************************************************************************** */

/*****************************************************************/
/* this socket fd is the one used to accept incoming connections */
/*****************************************************************/
static int hub_sck;

static void	new_incoming_connection(void)
{
	int sock_fd;
	struct sockaddr_in remote;
	int x=sizeof(remote);
	char *dummy1;
	int dummy_len;

	sock_fd=accept(hub_sck,(struct sockaddr *)&remote,&x);
	if(sock_fd==-1)
		return;

	/* we first check if someone doesn't try to flood the hub with dummy connection */
	if(get_tos_entry(CNX_TOSKEY,(char *)&(remote.sin_addr),sizeof(remote.sin_addr),0,&dummy1,&dummy_len)==1)
	{
		/*printf(stderr,"Connection attempt from the same ip in less than 10 seconds.\n"); */
		shutdown(sock_fd,SHUT_RDWR);
		close(sock_fd);
		return;
	}

	if(get_tos_entry(TBAN_TOSKEY,(char *)&(remote.sin_addr),sizeof(remote.sin_addr),0,&dummy1,&dummy_len)==1)
	{
		/*	fprintf(stderr,"Connection attempt from a temporary banned ip.\n"); */
		shutdown(sock_fd,SHUT_RDWR);
		close(sock_fd);
		return;
	}

	if(get_tos_entry(PBAN_TOSKEY,(char *)&(remote.sin_addr),sizeof(remote.sin_addr),0,&dummy1,&dummy_len)==1)
	{
		/* fprintf(stderr,"Connection attempt from a permanently banned ip.\n"); */
		shutdown(sock_fd,SHUT_RDWR);
		close(sock_fd);
		return;
	}

	/* put the address of the remote host in the CNX tos list */
	add_tos_entry(CNX_TOSKEY,10,(char *)&(remote.sin_addr),sizeof(remote.sin_addr),NULL,0);

	hub_handshake_register_new_fd(sock_fd,&(remote.sin_addr));
}

/**************************/
/* function called at end */
/**************************/
static int hub_sck_exit(const GED_CALLBACKS *ged)
{
	return 0;
}

/****************************/
/* add FD event to wait for */
/****************************/
static void hub_sck_add_fd(const GED_CALLBACKS *ged, GArray *struct_pollfd_array)
{
	struct pollfd nw;

	nw.fd=hub_sck;
	nw.events=POLLIN;
	nw.revents=0;

	g_array_append_val(struct_pollfd_array,nw);
}

/*******************************/
/* check for the arrived event */
/*******************************/
static void hub_sck_scan_fd(const GED_CALLBACKS *ged, GArray *struct_pollfd_array, int low_range, int high_range)
{
	/* because we have only 1 entry, its location is at the "low_range" of the struct_pollfd_array */
	struct pollfd *nw;

	nw=&(g_array_index(struct_pollfd_array,struct pollfd,low_range));

	if(nw->revents&POLLIN)
	{
		new_incoming_connection();
	}
}

/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/* ---------------------- initialization of the handler --------------------- */
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
static GED_CALLBACKS hub_sck_ged=
				{
					"hub_sck GED", /* ged_name For debug */
					hub_sck_exit, /* destructor */
					hub_sck_add_fd, 
					hub_sck_scan_fd,
               NULL,
               NULL,
               NULL,
					NULL
				};

/**************************************/
/* function initializing the hub_sck */
/**************************************/
GED_CALLBACKS *hub_sck_init(void)
{
	hub_sck=_x_tcp(cluster_port);
	if(hub_sck==-1)
	{
		fprintf(stderr,"Unable to create hub port.\n");
		/* unlike other GED, this function must not fail */
		exit(1);
	}
	listen(hub_sck,8);
	return &hub_sck_ged;
}

