/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * hub_cmd.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: hub_cmd.h,v 2.2 2003/02/04 06:18:16 eric Exp $
*/

#ifndef __HUB_CMD_H__
#define __HUB_CMD_H__

#include <stdarg.h>

#include "user_cnx_lst.h"

/*************************************************************************/
/* the given string has been sent to "Hub-Security", it may be a command */
/* This function processes the string and performs the wanted action     */
/*************************************************************************/
/* output: =0: ok                                */
/*         <0: fatal error (=> abort connection) */
/*         >0: recoverable error (continue)      */
/*************************************************/
int process_hub_command(LOCAL_USER_CNX_ENTRY *ptr,char *string);

/*************************************************************************/
/* the given string has been sent to any user but always starts with a + */
/* This function processes the string and performs the wanted action     */
/*************************************************************************/
/* output: =0: ok                                */
/*         <0: fatal error (=> abort connection) */
/*         >0: recoverable error (continue)      */
/*************************************************/
int process_user_hub_command(LOCAL_USER_CNX_ENTRY *ptr,char *string, char *remote_name);

/**************************************************************************************************/
/* in the same way as it exists for PERL scripts, there is an event handler for embedded commands */
/**************************************************************************************************/
/* evt_name and evt_emitter are the same as PERL scripts one */
/* ap is a va_list of nb_args (char *)                       */
/*************************************************************/
void hub_event_command(const char *evt_name, const char *evt_emitter, int nb_args, va_list ap);

#endif
