/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * ged_if.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: ged_if.h,v 2.1 2003/01/31 16:27:46 eric Exp $
*/

#ifndef __GED_IF_H__
#define __GED_IF_H__

typedef struct ged_callbacks
{
	const char *ged_name;	/* it is the name of the handler [mainly for debug] */

	/* function called to destroy a GED handler */
	/* ged is the value returned by the GED_INIT function */
	int (*ged_exit)(const struct ged_callbacks *ged);

	/* function called before the poll call to let GED adds its FD to the poll array */
	/* if ged_add_fd==NULL, the function is ignored */
	void (*ged_add_fd)(const struct ged_callbacks *ged, GArray *struct_pollfd_array);

	/* function called after the poll call to let GED scans the poll array for its information */
	/* if ged_scan_fd==NULL, the function is ignored */
	/* in the pollfd array, the entry [low_range:high_range[ have been register by the ged_add_fd function */
	void (*ged_scan_fd)(const struct ged_callbacks *ged, GArray *struct_pollfd_array, int low_range, int high_range);

	/* function called every 10 seconds */
	/* if ged_periodic==NULL, the function is ignored */
	void (*ged_periodic)(const struct ged_callbacks *ged);

	/* functions called each time the main loop ends and will restart */
	/* 3 functions can be defined, all always1 functions are called, then always2 then always3 */
	/* a NULL function is ignored */
	void (*ged_always1)(const struct ged_callbacks *ged);
	void (*ged_always2)(const struct ged_callbacks *ged);
	void (*ged_always3)(const struct ged_callbacks *ged);
} GED_CALLBACKS;

/***************************************************/
/* prototype of the registration function of a GED */
/***************************************************/
typedef GED_CALLBACKS *(*GED_INIT)(void);

#endif
