/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * g_string_ref.h: Copyright (C) Uriel Chemouni <uriel@adess.dyndns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: g_string_ref.h,v 2.0 2003/01/30 12:50:44 eric Exp $
*/

#ifndef __G_STRING_REF_H__
#define __G_STRING_REF_H__

typedef struct s_GString_ref
{
	GString *data;
	/* TODO */
	/* UNICODE_STRING */
	/* HTML_STRING */
	int count;
} GString_ref;

GString_ref *g_string_ref_new(const char *);
GString_ref *g_string_ref_sized_new(int size);

#define g_string_ref_sprintf(string, format, ...) g_string_sprintf(string->data, format, ...)
#define g_string_ref_sprintfa(string, format, ...) g_string_sprintfa(string->data, format, ...)

GString_ref *g_string_ref_append(GString_ref *string, const char *val);

GString_ref *g_string_ref_append_c(GString_ref *string, char c);

GString_ref *g_string_ref_prepend(GString_ref *string, const char *val);
GString_ref *g_string_ref_prepend_c(GString_ref *string, char c);

GString_ref *g_string_ref_insert(GString_ref *string, int pos, const char *val);
GString_ref *g_string_ref_insert_c(GString_ref *string, int pos, char c);

GString_ref *g_string_ref_truncate(GString_ref *string, int len);

GString_ref *conv_gstring_to_gstring_ref(GString *);
void *g_string_ref_free(GString_ref *);

#endif
