/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * e_db.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: e_db.c,v 2.0 2003/01/30 12:50:44 eric Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "gvar.h"
#include "e_db.h"

/**************************************************/
/* dump the db content into name,type,value.      */
/* if any input value==NULL, the value is created */
/**************************************************/
/* output: 0=ok, 1=error */
/*************************/
int get_all_db_keys(GPtrArray **name, GPtrArray **type, GPtrArray **value, GStringChunk **gsc)
{
	int nb_ret;
	char **ret;
	int i;

	if(*name==NULL)
		*name=g_ptr_array_new();

	if(*type==NULL)
		*type=g_ptr_array_new();

	if(*value==NULL)
		*value=g_ptr_array_new();

	if(*gsc==NULL)
		*gsc=g_string_chunk_new(32);

	/* there is currently no way to get the key list of an open DB, we must */
	/* close it first and reopen it after */
	G_LOCK(conf_file);
	e_db_close(conf_file);
	e_db_flush();
	ret=e_db_dump_key_list(conf_file,&nb_ret);
	/* conf_file=e_db_open(conf_filename); removed in DCHUB 0.2.0 */
	
	/* create the dump */
	for(i=0;i<nb_ret;i++)
	{
		char *tp;
		char bf[512];

		tp=e_db_type_get(conf_file,ret[i]);
		if(tp==NULL)
			continue;

		/* add the name to the array */
		g_ptr_array_add((*name),g_string_chunk_insert((*gsc),ret[i]));
		/* add the type to the array */
		g_ptr_array_add((*type),g_string_chunk_insert((*gsc),tp));

		/* convert the value into string */
		if(!strcmp(tp,"int"))
		{	
			/* value is an int */
			int vl;

			if(!e_db_int_get(conf_file,ret[i],&vl))
				vl=0;

			sprintf(bf,"%d",vl);
			g_ptr_array_add((*value),g_string_chunk_insert((*gsc),bf));
		}
		else if(!strcmp(tp,"float"))
		{
			/* value is a float */
			float vl;

			if(!e_db_float_get(conf_file,ret[i],&vl))
				vl=0.0;

			sprintf(bf,"%f",vl);
			g_ptr_array_add((*value),g_string_chunk_insert((*gsc),bf));
		}
		else
		{
			/* value is a string */
			char *vl;
			vl=e_db_str_get(conf_file,ret[i]);
			if(vl==NULL)
			{
				g_ptr_array_add((*value),g_string_chunk_insert((*gsc),""));
			}
			else
			{
				g_ptr_array_add((*value),g_string_chunk_insert((*gsc),vl));
				free(vl);
			}
		}

		free(tp);
	}
	G_UNLOCK(conf_file);

	/* and free the temp array */
	if(ret!=NULL)
	{
		for(i=0;i<nb_ret;i++)
		{
			free(ret[i]);
		}
		free(ret);
	}
	return 0;
}

