/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * common_define.hs: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: common_defines.h,v 2.6 2003/05/06 16:44:11 ericprev Exp $
*/

#ifndef __COMMON_DEFINES_H__
#define __COMMON_DEFINES_H__

typedef enum
{
	CNX_OPENED=0,        /* the connection is active */
	CNX_CLOSED,          /* the socket exists but is dead */
	CNX_WILL_DIE,        /* the socket exists but will die as soon as the output buffer is empty */
} CLOSE_STATUS;


#define MD_BLOC_SIZE 16

/* user flags */
#define SILENT_CC       1
#define SILENT_PM       2
#define SILENT_SR       4
#define SILENT_CNX      8
#define SHILD_MODE      16
#define LOCK_PM_TUTOR   32
#define REV_SILENT_CNX  64
#define OTIST_PM        128
#define OTIST_CC        256
#define USER_TBAN			512
#define USER_PBAN			1024

/* all extended display flags */
/* all values must be power of 2 */
enum edf
{
	HAVE_UTF8=1,            /* support UTF8 characters */
	HAVE_TAG=2,             /* support display tag to enhanced output */
	HAVE_XSEARCH=4,         /* support $XSearch and $XSR commands */
	HAVE_MD4x=8,            /* support $MD4Get0 and $MD4Set commands */
	HAVE_SENT_MYINFO=16,    /* the client have sent its MyINFO */
};

#endif
