/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * plugin_sample.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: plugin_sample.c,v 2.0 2003/01/30 12:50:44 eric Exp $
*/

#include <stdio.h>
#include <glib.h>

#include "dchub_plugin_api.h"

/*****************************/
/* a sample of event handler */
/*****************************/
static void myinfo_fnc(const GArray *param)
{
	PLUGIN_PARAM *pp;
	int i;

	if(param==NULL)
	{
		fprintf(stderr,"no parameter\n");
		return;
	}

	for(i=0;i<param->len;i++)
	{
		pp=&(g_array_index(param,PLUGIN_PARAM,i));

		printf("varname: '%s' => varval: '%s'\n",pp->varname,pp->varvalue);
	}
	return;
}

/*****************************************************/
/* this function is called when the plugin is loaded */
/*****************************************************/
int plugin_beginning(PLUGIN *plug)
{
	printf("beginning of the plugin\n");

	register_dchub_plugin_event(plug,"myinfo", myinfo_fnc);
	return 0;		/* success */
}

/************************************************************/
/* this function is called just before unloading the plugin */
/************************************************************/
int plugin_end(PLUGIN *plug)
{
	printf("end of the plugin\n");
	return 0;		/* success */
}

