/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * dctc_process.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: dctc_process.h,v 1.8 2003/12/28 09:29:32 uid68112 Exp $
*/

#ifndef __DCTC_PROCESS_H__
#define __DCTC_PROCESS_H__

#include <gdk/gdk.h>

#include "global_user.h"
/*************************************************************/
/* close the connection to the current DCTC client if exists */
/*************************************************************/
void close_current_dctc(void);

/**********************************************************************************/
/* this function is called when something comes from DCTC client                  */
/* data is always NULL, source == current_dctc_fd and condition == GTK_INPUT_READ */
/**********************************************************************************/
void process_data_from_dctc(gpointer data, gint source, GdkInputCondition condition);

/**********************************************************************************/
/* this function is called when something comes from DCTC client                  */
/* data is always NULL, source == current_dctc_fd and condition == GTK_INPUT_READ */
/**********************************************************************************/
/* technically, the function performs exactly the same tasks as the previous one */
/* except it uses gdl_dctc instead of current_dctc *DCTC_COM                     */
/*********************************************************************************/
void process_data_from_gdl_dctc(gpointer data, gint source, GdkInputCondition condition);

/************************************************************************************/
/* same function as previous one except it tries to send queued data to DCTC client */
/************************************************************************************/
void process_data_to_dctc(gpointer data, gint source, GdkInputCondition condition);

/****************************************/
/* send data to the current DCTC client */
/* the function handles all errors      */
/****************************************/
void send_data_to_dctc(char *str);

/************************************/
/* send data to the GDL DCTC client */
/* the function handles all errors  */
/************************************/
void send_data_to_gdl_dctc(char *str);

/************************************************/
/* open password dialog to enter a new password */
/************************************************/
void enter_passwd_fnc(const GString *in);

/*****************************************************************/
/* create autoscan configuration window for selected GDL entries */
/*****************************************************************/
void create_autoscan_window_for_selected_gdl_entry(void);

/*************************************************/
/* create rename window for selected GDL entries */
/*************************************************/
void create_rename_window_for_selected_gdl_entry(void);

/*************************************************/
/* create rename window for selected GDL entries */
/*************************************************/
void create_script_window_for_selected_gdl_entry(void);

/**********************************************************************/
/* kill upload or download task using their ID (and /KILL or /KILLKB) */
/**********************************************************************/
void kill_selected_entry(char *cmd,char *clist_name, int clist_row);

/*********************************************************************************************/
/* foreach selected line, send the given command followed by the content of the given column */
/*********************************************************************************************/
void foreach_selected_entry_send_cmd(char *cmd,char *clist_name, int column_num);
void foreach_selected_entry_send_cmd_to_gdl(char *cmd,char *clist_name, int column_num);

/**********************************************************************************************************/
/* foreach selected line, send the given command followed by the nickname of the row (GLOB_USER required) */
/**********************************************************************************************************/
void foreach_selected_entry_send_cmd_with_glob_user(char *clist_name, int column_num,char *cmd);
void foreach_selected_entry_send_cmd_to_gdl_with_glob_user(char *clist_name, int column_num, char *cmd);

/******************************/
/* end the FLST clist refresh */
/******************************/
void user_share_full_list_fnc(const GString *in);

/************************/
/* reset the xfer lists */
/************************/
/* input: NULL */
/***************/
void begin_xfer_list_fnc(const GString *s);

#endif
