/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * gui_define.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: gui_define.h,v 1.1 2004/01/13 18:10:29 ericprev Exp $
*/

#ifndef __GUI_DEFINE_H__
#define __GUI_DEFINE_H__

/*
 meaning of () values:

wo => write only. This value should never been read to perform task. There is
      always another column in the same model containing the "unformatted"
      version. For numeric "unformatted" value, this column probably contains
      a "locale" formatted one. For string "unformatted" value, this column
      is the UTF-8 version (required to be displayed correctly).
		This column is displayed in a view.
org => read/write value. It is the value as it was received from the client
      (it is an "unformatted" value).  This column is NOT displayed in a view.
*/

/* list of all columns of the "bittorrent_clist" tree_view */
enum
{
	BTC_FILENAME_COL=0,	/* char * (wo) */
	BTC_SIZE_COL,			/* char * (wo) */
	BTC_STATUS_COL,		/* char * (wo) */
	BTC_DL_SPEED_COL,		/* char * (wo) */
	BTC_UL_SPEED_COL,		/* char * (wo) */
	BTC_DL_SPEED,			/* gfloat: unformatted value of BTC_DL_SPEED_COL */
	BTC_UL_SPEED,			/* gfloat: unformatted value of BTC_UL_SPEED_COL */
	BTC_BACKGROUND_COL,	/* char *: background color */
	BTC_BITTORRENT_PID,	/* gint: pid of the bittorrent process */
	NB_BTC_COL
};

#endif
