#
#  $Id: Makefile.inc,v 1.66 2007-07-06 16:10:52 tigran Exp $
#


#
#  put here all sources which becomes an executable
#

ERR = /dev/null
BIN_SRC = dcap_test.c dccp.c wdccp.c dcsuck.c readv_test.c

SRC = dcap.c \
	char2crc.c \
	array.c \
	dcap_error.c \
	pnfs.c \
	io.c \
	system_io.c \
	input_parser.c \
	dcap_poll.c \
	dcap_interpreter.c \
	dcap_command.c \
	dcap_mqueue.c \
	dcap_debug.c \
	dcap_signal.c \
	dcap_version.c \
	node_plays.c \
	links.c \
	dcap_url.c \
	dcap_ahead.c \
	dcap_accept.c \
	socket_nio.c \
	dcap_reconnect.c \
	tunnelManager.c \
	lineparser.c \
	dcap_protocol.c \
	string2stat.c \
	dcap_read.c \
	dcap_open.c \
	dcap_close.c \
	dcap_write.c \
	dcap_lseek.c \
	dcap_stream.c \
	dcap_stat.c \
	adler32.c \
	dcap_checksum.c \
	dcap_dup.c \
	dcap_fsync.c \
	dcap_access.c \
	dcap_dirent.c \
	xutil.c \
	dcap_unlink.c \
	dcap_mkdir.c \
	dcap_chmod.c \
	dcap_rename.c \
	dcap_chown.c \
	str2errno.c \
	passive.c


ifdef TRACEBACK
	SRC += gettrace.c linux_trace.c
	LIBS += -lbfd -liberty
	CFLAGS += -DDC_CALL_TRACE
endif


OBJS = $(sort ${SRC:.c=.o})
BIN_EXEC = ${BIN_SRC:.c=} 

STORE_FLAGS :=  $(shell echo $(CFLAGS) | sed -e 's/\"//g')

all: libdcap libpdcap $(BIN_EXEC)

$(OBJS): Makefile.inc

libdcap: libdcap$(SO_EXT)
libpdcap: libpdcap$(SO_EXT)


mapfile: dcap.h
	@grep -v include dcap.h > dcap.h_map
	$(CPP) $(CFLAGS) dcap.h_map | ./mkmapfile.sh > mapfile
	@rm -f dcap.h_map


libdcap$(A_EXT): $(OBJS) 
	$(AR) $(ARFLAGS) $@ $(OBJS)
	$(RANLIB) $@

libdcap$(SO_EXT): libdcap$(A_EXT) mapfile
	$(LD) $(LDFLAGS) $(MAP) $(SO_INIT) -o $@ $(OBJS) $(LIBS)

dccp: $(OBJS) $(DCAP_O) dccp.o
	$(CC) $(EXE_INIT) -o $@$(EXE_EXT) dccp.o $(OBJS) $(DCAP_O) $(LIBS)

dcsuck: $(OBJS) $(DCAP_O) dcsuck.o
	$(CC) $(EXE_INIT) -o $@$(EXE_EXT) dcsuck.o $(OBJS) $(DCAP_O) $(LIBS)

readv_test: $(OBJS) $(DCAP_O) readv_test.o
	$(CC) $(EXE_INIT) -o $@$(EXE_EXT) readv_test.o $(OBJS) $(DCAP_O) $(LIBS)

wdccp: $(OBJS) $(DCAP_O) wdccp.o
	$(CC) $(EXE_INIT) -o $@$(EXE_EXT) wdccp.o $(OBJS) $(DCAP_O) $(LIBS)

dc_stage: $(OBJS) $(DCAP_O) dc_stage.o
	$(CC) $(EXE_INIT) -o $@ dc_stage.o $(OBJS) $(DCAP_O) $(LIBS)

dc_check: $(OBJS) $(DCAP_O) dc_check.o
	$(CC) $(EXE_INIT) -o $@ dc_check.o $(OBJS) $(DCAP_O) $(LIBS)

libpdcap$(SO_EXT): $(OBJS) dcap_preload.o dcap_preload64.o
	$(LD) $(LDFLAGS) $(SO_INIT) -o $@ dcap_preload.o dcap_preload64.o $(OBJS) $(LIBS)

dcap_test: libdcap$(SO_EXT) dcap_test.o
	$(CC) -o $@ dcap_test.o -I. -L. -ldcap $(LIBS)


depend: debug_level.h debug_map.h
	@rm -f .depend
	@echo "Making dependencies..."
	@echo $(CFLAGS) |  grep "REENTRANT" >/dev/null 2>&1; \
	if [ "$$?" = "0"  ]; \
	then \
		cat dcap.h.in | sed -e 's/DCAP_THREAD_FLAG/_REENTRANT/' > dcap.h; \
	else \
		cp dcap.h.in dcap.h; \
	fi
	@$(MAKEDEP) $(CFLAGS) $(DCAP_SRC) $(BUN_SRC) $(SRC) > .depend  2>$(ERR)


debug_level.h: debug_level.lst
	@ grep -v "^#" debug_level.lst |tr '[a-z]' '[A-Z]' | awk '\
		BEGIN { \
			print "#ifndef DEBUG_LEVEL_H"; \
			print "#define DEBUG_LEVEL_H"; \
			print "/* This file generated by make procedure */"; \
			print ""; \
		} \
		{ \
			if( NF != 2 ) next; \
			print "#define DC_" $$1 " " $$2; \
		} \
		END { \
			print ""; \
			print "#endif /* DEBUG_LEVEL_H */"; \
		} '  > debug_level.h


debug_map.h: debug_level.lst
	@ grep -v "^#" debug_level.lst | awk '\
		BEGIN { \
			i = 0; \
			print "#ifndef DEBUG_MAP_H"; \
			print "#define DEBUG_MAP_H"; \
			print "/* This file generated by make procedure */"; \
			print ""; \
			print "static debugMap debugMapArray[] = {"; \
		} \
		{ \
			if( NF != 2 ) next; \
			print "\t{ " $$2 ",\t\"" $$1 "\"},"; \
		} \
		END { \
			print "\t{ -1,\tNULL}" ; \
			print ""; \
			print "};"; \
			print ""; \
			print "#endif /* DEBUG_MAP_H */"; \
		} '  > debug_map.h


dcap_version.o: dcap_version.c
	$(CC) -c $< $(CFLAGS) -D__CFLAGS__=\""$(STORE_FLAGS)"\"

include .depend
