#ifndef SETTINGSMAPPER_H__
#define SETTINGSMAPPER_H__

#include <dcpp/stdinc.h>
#include <dcpp/DCPlusPlus.h>
#include <dcpp/SettingsManager.h>
#include <map>
#include <boost/any.hpp>
using namespace std;

//! Maps settings between dc-qt and dc++ format, keys have same names but as strings.
class SettingsMapper
{
 public:
  boost::any getSetting(const string& key);
  void setSetting(const string& key,const boost::any& value);
  static SettingsMapper* instance() {if(!inst) inst=new SettingsMapper;return inst;}
private:
  static SettingsMapper* inst;
  SettingsMapper();
  map<string,int> sm;
};



#endif
