package DBIShell::Gtk;

use strict;
use DBIShell;
use DBIShell::UTIL qw(TRUE FALSE);
use Exporter ();

use Gtk;
use Gtk::Atoms;
#use Gtk::Keybinding qw(:modifiers);

use DBIShell::Gtk::main;
use DBIShell::Gtk::conn;
#use DBIShell::Gtk::help;
#use DBIShell::Gtk::rbug;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $VERSION);

@ISA         = qw(DBIShell);
@EXPORT      = ();
@EXPORT_OK   = ();
%EXPORT_TAGS = ();
$VERSION     = 0.01_02;

sub new ($)
{
    my $sh;
    my $ext;
    my $idir;
    my $package = ref($_[0]) ? ref(shift(@_)) : $_[0];

#::    $idir = '<%SDIR%>';

    $idir ||= '.';
    $sh  = $package->_obj_struct();
    $ext = $sh->{GTK} =
    {
     CONTROL => undef(), # 'main' window
     DATA    => [],      # data display windows
     HELP    => [],      # help windows
     SHARE   => $idir,   # where is our equivalent of '/usr/share/dbishell'
    };

    return bless( $sh, $package );
}

sub _share ($) { return $_[0]->{GTK}{SHARE} }

sub start ($)
{
    my $sh = $_[0];

    # add a bit here to spawn a db-interaction panel if we have enough args to
    # connect.

    $sh->DBIShell::Gtk::main::panel();
}


__END__

	#print(STDERR "XPM ( ", $_->[TL_XPM], " ) >> ");
	#print(STDERR $icon, "\n");
