#!/usr/bin/perl
#
#
# dbengine.cgi
# see closer information at http://www.cis-computer.com/dbengine
#
# Version 1.1
# <c> 2001
#
# Ingo Ciechowski		ic	<ciechowski@cis-computer.com>
#
#
# thanx to contributions of
# Jaime Cervera Bravo		jb	<jcervera@aq.upm.es>
# John Goerzen			jg	<jgoerzen@complete.org>
# Werner Modenbach		wm	<modenbach@alc.de>
# Rudolf Lippan			rl	<rlippan@elastic.com>
# Florian Rossol		fr	<Florian.Rossol@stud.uni-hannover.de>
# Matt Murdock			m2	<Matthew@BMEi.on.ca>
# William McKee			wlm	<william@knowmad.com>

require 5.003;

BEGIN {
	### USER-DEFINED VALUES ####
	# Location of configuration file (use absolute path) - WLM 01/06/01
	# Experimental - it's safest to keep this file outside of the httpd directories;
	# it will eventually contain database passwords and other sensitive data
	$config_file	= "/usr/home/ciscompu/www/conf/dbengine.conf";
	
	# Set this value if you have locally installed modules such as DBI or Log.PM file; 
	# separate multiple directories by a space  - WLM 01/06/01
	my @path_to_local_modules   = qw[ /usr/home/ciscompu/usr/local/lib/perl5/lib ];
	### END USER-DEFINED VALUES ####
	### All other variables should be defined via configuration file
		
	## Add path(s) to local modules - WLM 01/06/01
	# Check for 'auto' directory within the paths; this must be manually added when not using lib
	foreach my $dir (@path_to_local_modules) {
		if (-d "$dir/auto") {
			unshift @INC, "$dir/auto";
			unshift @INC, $dir;
		} else {
			unshift @INC, $dir;
		}
	}
}


# load essential modules
use CGI;
use DBI;
use util::LOG;
use File::Basename;

use CGI::Carp qw / fatalsToBrowser /;

#
# Read the config file - WLM 01/06/01
if(-e $config_file) {
	&readCFG($config_file);
	$scriptname = ${cgis} . basename $0;
} else {
	die("Config file $config_file not found.");
}

#
# we first of all create a new query-CGI and get our
# most essential parameters as follows:
$query		= new CGI;
$starttime 	= time();
$newtime	= $query->param('xmin');
$dbase		= $query->param('dbase');	# (optional) name of the database to connect
$dbdesc		= $query->param('dbdesc');	# (optional) name of database with all these additional display and relation information
$order		= GetOrderBy($query->param('orderby'));
$table		= $query->param('table');	# (optional) name of the table to use
$oid		= $query->param('oid');		# (optional) ID of the record to work with
$search		= $query->param('search');	# (optional) SQL statement for a user-chosen selection
$childfield	= $query->param('childfield');	# (optional) fieldname of relation field
$childpreset	= $query->param('childpreset');	# (optional) preset data for relation field
$mode		= $query->param('mode');	# (optional) working mode for dbengine.cgi as follows
						#	  menu:	generates a menu with list of all tables on the fly
						#	 plain:	generates a dialog that allows for entering values to either add new records or search for existing ones
						#		if called with $oid set this mode will show the contents of the so given record and allow to update/delete the record
						#	delete:	ask whether our user really wants to delete the record $oid in $table and $dbase
						#      confdel:	delete the record $oid in $table and $dbase
						#	update:	update the record $oid in $table and $dbase with the additional data in $query
						#	   add:	add a new record to $table and $dbase with the additional data in $query
						#	search:	search all records in $table and $dbase that match the additional data in $query
						#	 empty:	generates an empty page on the fly
$modeX		= $query->param('mode.x');	# (optional) working mode for dbengine.cgi as follows
						#	  0-55:	plain
						#	56-110:	add
						#      111-165:	update
						#      166-220:	delete
						#      221-275:	search

#
# rl needs to be deleted so that it does not cause a problem 
# rl with listing all records, but needs a better fix in
# rl list tables to cover the posibility of params that are not
# rl fields in the database.
$query->delete('dbdesc');
$query->delete('orderby');

#
# M2: Set the menu background image dynamically, based on the database name
$menuBackground = "$bgPath$dbase$bgType" if (length($dbase));

#
# verify existance of background images
undef $menuBackground unless(-e "$htdocs$bgPath$menuBackground");
undef $mainBackground unless(-e "$htdocs$bgPath$mainBackground");

#
# initialize button strings according to laguage set
if ($language eq "german") {
	$buttons{'search'}	= "suchen";
	$buttons{'plain'}	= "suchen/hinzufuegen";
	$buttons{'update'}	= "aendern";
	$buttons{'undef'}	= "Undef";
	$buttons{'mupdate'}	= "mehrfach aendern";
	$buttons{'delete'}	= "loeschen";
	$buttons{'confdel'}	= "wirklich loeschen";
	$buttons{'add'}		= "hinzufuegen";
	$buttons{'reset'}	= "Formular zuruecksetzen";
	$buttons{'true'}	= "Ja";
	$buttons{'false'}	= "Nein";
	$buttons{'list'}	= "Liste";
	$buttons{'new'}		= "neu";
	$buttons{'edit'}	= "bearbeiten";
} else {
	$buttons{'search'}	= "search";
	$buttons{'plain'}	= "search/add";
	$buttons{'update'}	= "update";
	$buttons{'undef'}	= "undef";
	$buttons{'mupdate'}	= "multiupdate";
	$buttons{'delete'}	= "delete";
	$buttons{'confdel'}	= "remove record";
	$buttons{'add'}		= "add";
	$buttons{'reset'}	= "reset form";
	$buttons{'true'}	= "true";
	$buttons{'false'}	= "false";
	$buttons{'list'}	= "list";
	$buttons{'new'}		= "new";
	$buttons{'edit'}	= "edit";
}


#
# let's first of all create a new CGI instance to seperate our 
# input from our output  and print the HTML header to our browser
$output = new CGI('');
print $query->header;

#
# start logging
$log	= new LOG;


#
# load basic functionality
require "./util/base.pl";


#
# choose database specific code
if(-e "./util/${dbasetype}.pl") {
	require "./util/${dbasetype}.pl";
	&db_initVars();
	&db_connect2database();
} else {
	die("Database $dbasetype not supported");
}


#
# set maximum field length when working with fields of
# unspecified length
$dbdconn->{LongReadLen} = 16384;
$dbconn->{LongReadLen} = 16384;


#
# if there's no mode specified, but a modeX set, we'll translate the picture input here
#	0-55: plain
#     56-110: add
#    111-165: update
#    166-220: delete
#    221-275: search
if (!$mode && $modeX) {
	$mode	= "plain"	if $modeX>=0	&& $modeX<=55;
	$mode	= "add"		if $modeX>=56	&& $modeX<=110;
	$mode	= "update"	if $modeX>=111	&& $modeX<=165;
	$mode	= "delete"	if $modeX>=166	&& $modeX<=220;
	$mode	= "search"	if $modeX>=221	&& $modeX<=275;
	$query->delete('mode.x');
	$query->delete('mode.y');
}


#
# if there's no $table specified we'll generate
# a frameset on the fly that shows a menu and some empty space
unless ($table) {
	if($mode eq "menu") {
		&createMenu ($output);

	} elsif($mode eq "empty") {
		print $output->start_html(-title=>"empty page", -BGCOLOR=>$bgcol, -BACKGROUND=>$mainBackground);
		print $output->end_html;

	} else {
		&createMainFrame ($output);
	}

#
# otherwise we'll check the 'mode' argument to find out what to do...
} elsif($mode eq $buttons{'delete'} || $mode eq "delete" || $mode eq "confdel" || $mode eq $buttons{'confdel'}) {
	&checkModification ($query, $output);
	&doDeleteRecord ($query, $output);

} elsif($mode eq $buttons{'search'} || $mode eq "search") {
	$mode	= "search";
	&listTable ($output);

} elsif($mode eq $buttons{'update'} || $mode eq "update") {
	&checkModification ($query, $output);
	&doUpdateRecord ($query, $output);
	$query->delete_all;
	&listTable ($output);

} elsif($mode eq $buttons{'mupdate'} || $mode eq "mupdate") {
	&doUpdateMultipleRecords ($query, $output);
	$query->delete_all;
	&listTable ($output);

} elsif($mode eq $buttons{'add'} || $mode eq "add") {
	&doAddRecord ($query, $output);

#
# generate a dialog that allows for entering values to either add new records or search for existing ones
} elsif($mode eq $buttons{'plain'} || $mode eq "plain" ) {
	 &plainDialog ($output);

} elsif($mode eq $buttons{'new'} || $mode eq "new" ) {
	$oid	="";
	$search	="";
	&plainDialog ($output);

#
# finally give our caller a hint that he made an error...
} else {
	print $output->start_html(-title=>"empty page", -BGCOLOR=>$bgcol, -BACKGROUND=>$mainBackground);
	print "<H4><FONT COLOR=BLACK><P>$scriptname called with illegal arguments:</H4>\n\n<TABLE BORDER CELLSPACING=0 CELLPADDING=5>\n";
	@names	= $query->param;
	foreach $name (sort @names) {
		print "<TR><TD>$name<TD>" . $query->param($name) . "\n";
	}
	print "</TABLE>\n";
	print $output->end_html;
}

$dbconn->disconnect;
$dbdconn->disconnect;
exit;


##########################################################
# HELPER SUBROUTINES
##########################################################

sub GetOrderBy {
	$orderby=$_[0];
	if ($orderby) {
		# a check for validity of data should go here;
		$order = "ORDER BY $orderby";
	} else {
		$order='';
	}
	return $order;
}


sub readCFG {
	my ($filename) = @_;
	my ($mode, $varname, $content, %xnames);
	open (CFG, "<$filename") or die "Unable to open configuration file ($filename): $!";
	while (<CFG>) {
		s/^\s*\#.*//g;		# remove comments
		s/^\s+//g;		# remove leading whitespace
		next if /^$/;		# skip empty lines
		if ( /\[([^]]+)\]/ ) {	# identify mode
			$mode = $1;
			next;
		}
		# split cfg line and cleanup entries for Taint-mode
		# also accept standard Perl variable assignment syntax
		if(/\$([^\s\=]+)\s*\=\s*([^\;]+)\;/) {
			$varname = $1;
			$content = $2;
			$content = $1 if($content =~ /^\"([^\"]*)\"$/);
			$content = $1 if($content =~ /^\'([^\']*)\'$/);

		# if in text/tab style
		} else {
			s/^\s+//g;		# remove leading whitespace
			next if /^$/;		# skip empty lines
			($varname, $content) = split(/\s+/, $_);
		}
		$varname =~ /(.*)/;
		$varname = $1;
		$content =~ /(.*)/;
		$content = $1;

		#
		# lines in the [CONFIG] section are evaluated
		# to initialize according global variables
		if($mode =~ /CONFIG/i) {
			eval "\$$varname = \"$content\"\n";


		#
		# lines in the [X-NAMES] section are saved in the %xnames array
		} elsif($mode =~ /X-NAMES/i) {
			$xnames{$varname} = $content;
		}
	}
	close CFG;
}
