#include <string>
#include <iostream>
#include <ace/Log_Msg.h>
#include <ace/Synch.h>

#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>


class DBPooledConection;
class DBHostConfig;
class DBBalancerConfig;
class DBPostgresBackend;
class DBPostgresFrontend;

class DBPostgresPooledConnection: public virtual DBPooledConnection {

public:

  DBPostgresPooledConnection(DBBalancerConfig* config, DBHostConfig* host, string id);
  DBPostgresPooledConnection() {};
  ~DBPostgresPooledConnection();

  // Implementacin del interfaz DBPooledConnection

  bool handleConnection(int socket);
  bool checkConnection();
  bool isFree();
  bool isValid();

  DBPooledConnection *usable();
  DBPooledConnection *testable();

  void closeConnection();


private:


  void cleanUp();
  //bool interceptFrontEndMessage(int fe_socket, int be_socket, char *message, int size,  bool first);
  
  bool handleConnectionFrontendError(string message, bool state, int socket);
  bool handleConnectionBackendError(string message, int be_number, int socket);
  // Connection close handle
  bool handleConnectionClose(int socket);

  // Private attributes.

  const static unsigned int SEND_FLAGS = 0;
  const static unsigned int RECV_FLAGS = 0;
  const static unsigned int MAX_LOOP_ITERATIONS = 1000;

  // FE connection data. Used for incoming connections.

  DBPostgresFrontend *_fe;

  // BE connection data. Used for the connection to a Backend

  DBPostgresBackend *_be;

  ACE_Thread_Mutex _mutex;
  bool _valid;
  bool _free;

};

