/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
package com.db4odoc.android.compare.refactored;

import java.io.FileNotFoundException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import android.widget.TextView;

public class SqlExample {

	private static final String DATABASE_NAME = "android";
	private static final String DB_TABLE_PILOT = "pilot";
	private static final String DB_TABLE_CAR = "car";
	private static final int DATABASE_VERSION = 1;

	private static SQLiteDatabase _db = null;
	private static Context _context = null;
	private static TextView _console = null;

	public static void init(Context context, TextView console) {
		_context = context;
		_console = console;
	}

	// end init

	public static void init(Context context) {
		_context = context;
	}

	// end init

	public static SQLiteDatabase database() {
		long startTime = 0;
		try {
			_db = _context.openDatabase(DATABASE_NAME, null);
		} catch (FileNotFoundException e) {
			try {
				_db = _context.createDatabase(DATABASE_NAME, DATABASE_VERSION,
						0, null);
				_db.execSQL("create table " + DB_TABLE_PILOT + " ("
						+ "id integer primary key autoincrement, "
						+ "name text not null, " + "points integer not null);");
				// Foreign key constraint is parsed but not enforced
				// Here it is used for documentation purposes
				_db.execSQL("create table " + DB_TABLE_CAR + " ("
						+ "id integer primary key autoincrement,"
						+ "model text not null," + "pilot integer not null,"
						+ "FOREIGN KEY (pilot)"
						+ "REFERENCES pilot(id) on delete cascade);");
				_db.execSQL("CREATE INDEX CAR_PILOT ON " + DB_TABLE_CAR
						+ " (pilot);");
				upgradeDatabase(_db);
			} catch (FileNotFoundException e1) {
				_db = null;
			}
		}
		logToConsole(startTime, "Database opened: ", false);
		return _db;
	}

	// end database

	public static void upgradeDatabase(SQLiteDatabase db) {
		db.execSQL("create table REG_RECORDS ("
				+ "id text primary key," + "year date);");
		db.execSQL("CREATE INDEX IDX_REG_RECORDS ON REG_RECORDS (id);");
		db.execSQL("alter table " + DB_TABLE_CAR + " add reg_record text;");

	}

	// end upgradeDatabase

	private static void logToConsole(long startTime, String message, boolean add) {
		if (_console != null) {
			long diff = 0;
			if (startTime != 0) {
				diff = (System.currentTimeMillis() - startTime);
			}
			if (add) {
				_console.setText(_console.getText() + "\n" + message + diff
						+ " ms.");
			} else {
				_console.setText("SQLite: " + message + diff + " ms.");
			}
		}
	}

	// end logToConsole

	/**
	 * Close database connection
	 */
	public static void close() {
		if (_db != null) {
			long startTime = System.currentTimeMillis();
			_db.close();
			logToConsole(startTime, "Database committed and closed: ", false);
			_db = null;
		}
	}

	// end close

	public static void fillUpDB() throws Exception {
		close();
		_context.deleteDatabase(DATABASE_NAME);
		SQLiteDatabase db = database();
		if (db != null) {
			long startTime = System.currentTimeMillis();
			for (int i = 0; i < 100; i++) {
				addCar(db, i);
			}
			logToConsole(startTime, "Stored 100 objects: ", false);
			startTime = System.currentTimeMillis();
		}
	}

	// end fillUpDB

	
	public static void selectCarAndUpdate() {
		SQLiteDatabase db = database();
		if (db != null) {
			long startTime = System.currentTimeMillis();
			
			db.execSQL("insert into REG_RECORDS (id,year) values ('A1', DATETIME('NOW'))");
			ContentValues updateValues = new ContentValues();
	        
	    	// update car
	        updateValues.put("reg_record", "A1");
	        int count = db.update(DB_TABLE_CAR, updateValues, "pilot in (select id from pilot where points = 15)", null);
	        if (count == 0){
	        	logToConsole(0, "Car not found, refill the database to continue.", false);
	        } else {	
	        	Cursor c =
	                db.query("select c.model, r.id, r.year from car c, " +
	                		"REG_RECORDS r, pilot p where c.reg_record = r.id " +
	                		"and c.pilot = p.id and p.points = 15;", null);
	            if (c.count() == 0) {
	            	logToConsole(0, "Car not found, refill the database to continue.", false);
	            	return;
	            }
	            c.first();
	            String date = c.getString(2);
	            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd H:mm:ss");
	            try {
	            	Date dt = sf.parse(date);
	            	RegistrationRecord record = new RegistrationRecord(c.getString(1), dt);
		            
		            Car car = new Car();
		            car.setModel(c.getString(0));
		            car.setRegistration(record);
		            logToConsole(startTime, "Updated Car (" + car + "): ", true);
	            } catch (ParseException e){
	            	Log.e(Db4oExample.class.getName(), e.toString());
	            }
	            
	        }
		}
	}

	// end selectCarAndUpdate

	private static void addCar(SQLiteDatabase db, int number) {
		ContentValues initialValues = new ContentValues();

		initialValues.put("id", number);
		initialValues.put("name", "Tester");
		initialValues.put("points", number);
		db.insert(DB_TABLE_PILOT, null, initialValues);

		initialValues = new ContentValues();

		initialValues.put("model", "BMW");
		initialValues.put("pilot", number);
		db.insert(DB_TABLE_CAR, null, initialValues);
	}
	// end addCar

}
