/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;
using System.Runtime.Remoting.Channels.Tcp;

using Interfaces;


/*
 * Server class. Starts Remoting server services
 */

namespace Server
{
    class Program
    {
        static void Main(string[] args)
        {
            // Using an HttpChannel
            HttpChannel channel = new HttpChannel(65101);
            ChannelServices.RegisterChannel(channel);

            // Register test interface
            Type iTest = Type.GetType("Server.Test");
            RemotingConfiguration.RegisterWellKnownServiceType(
                    iTest,
                    "TestEndPoint",
                    WellKnownObjectMode.Singleton
                );

            Console.WriteLine("Test Service is ready.");

            // Keep the server running until the user presses
            // the Enter key.
            //
            Console.WriteLine("Services are running. Press Enter to end...");
            Console.ReadLine();

        }
        // end Main
    }
}
