/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.IO;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;
using System.Runtime.Remoting.Channels.Tcp;

using Interfaces;

namespace RemotingExample
{
    class Program
    {
        private const string Db4oFileName = "reference.db4o";

        // Reference to remote ITest implementation.
        ITest testRemoteReference;

        public Program()
        {
            string url;
            // delete db4o file to run an example on a single object
            File.Delete(Db4oFileName);

            // Setup a client channel to our services.
            HttpChannel channel = new HttpChannel(0);
            url = @"http://LocalHost:65101/";

            // Register the channel
            ChannelServices.RegisterChannel(channel, false);

            // Setup remote access to ITest implementation
            MarshalByRefObject obj = (MarshalByRefObject)RemotingServices.Connect(
                typeof(Interfaces.ITest), url + "TestEndPoint"
                );

            // Set a test object
            testRemoteReference = obj as Interfaces.ITest;

        }
        // end Program

        private void RunTest()
        {
            // Change data in the remote object
            testRemoteReference.ChangeData("test string");
            System.Console.WriteLine(testRemoteReference.GetData());
            // Store the object remotely to the database
            testRemoteReference.StoreData();
            // Retrieve the object data from the remote database
            System.Console.WriteLine(testRemoteReference.RetrieveData());

        }
        // end RunTest

        static void Main(string[] args)
        {
            new Program().RunTest();
        }
        // end Main
    }
}
