/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.IO;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;
using System.Runtime.Remoting.Channels.Tcp;

using RemotingClasses;

/*
 * Client test class. Creates a test object and passes it over the network 
 * to be stored to the database.
 */
  
namespace RemotingExample
{
    class Program
    {

        // Remote test proxy
        TestValueServer testServer;
        
        public Program()
        {
            string url;

            // Setup a client channel to our services.
            HttpChannel channel = new HttpChannel(0);
            url = @"http://LocalHost:65101/";

            // Register the channel
            ChannelServices.RegisterChannel(channel, false);

            // Set an access to the remote proxy
            testServer = (TestValueServer)RemotingServices.Connect(
                typeof(RemotingClasses.TestValueServer), url + "TestValueEndpoint"
                );
        }
        // end Program

        static void Main(string[] args)
        {
            new Program().RunTest();
        }
        // end Main

        private void RunTest()
        {
            // Remote persistent class 
            TestValue testValue;
            testValue = new TestValue();
            // Modify local TestValue object
            testValue.ChangeData("Test value");
            // Pass testValue to the server through testServer
            testServer.TestValue = testValue;
            // Call method on the server to store the testValue object
            testServer.StoreData();
            // Test what is stored to the database
            string result = testServer.RetrieveData();
            System.Console.WriteLine(result);
        }
        // end RunTest
    }
}
