' Copyright (C) 2007 db4objects Inc. http://www.db4o.com 

Imports System
Imports System.IO

Imports Db4objects.Db4o


Namespace Db4objects.Db4odoc.SystemInfo

    Class SystemInfoExample

        Private Const Db4oFileName As String = "reference.db4o"

        Private Const LogFileName As String = "db4o.log"

        Private Const MaxDbSize As Long = 20000000

        Private Const MaxFsSize As Long = 2000000

        Private Shared _container As IObjectContainer = Nothing

        Private Shared _logWriter As TextWriter = Nothing

        Public Shared Sub Main(ByVal args As String())
            Initialize()
            TestSystemInfo()
            Close()
        End Sub
        ' end Main

        Private Shared Sub TestSystemInfo()
            Dim dbSize As Long = _container.Ext().SystemInfo().TotalSize()
            Dim fsSize As Long = _container.Ext().SystemInfo().FreespaceSize()
            If dbSize > MaxDbSize Then
                System.Console.WriteLine("Attention! Database file size is over the limit. Maintenance required")
            End If
            _logWriter.WriteLine("Total database size: " + dbSize.ToString())
            If fsSize > MaxFsSize Then
                System.Console.WriteLine("Attention! Freespace size is over the limit. Maintenance required")
            End If
            _logWriter.WriteLine("Database freespace size: " + fsSize.ToString())
            _logWriter.WriteLine("Database freespace entries: " + _container.Ext().SystemInfo().FreespaceEntryCount().ToString())
        End Sub
        ' end TestSystemInfo

        Private Shared Sub Initialize()
            _logWriter = New StreamWriter(LogFileName)
            Try
                _container = Db4oFactory.OpenFile(Db4oFileName)
            Catch ex As DatabaseFileLockedException
                System.Console.WriteLine(ex.Message)
            End Try
            _logWriter.WriteLine("Database check-up: " + DateTime.Now.ToString())
        End Sub

        ' end Initialize

        Private Shared Sub Close()
            If _container IsNot Nothing Then
                _container.Close()
                _container = Nothing
            End If
            _logWriter.WriteLine("Done.")
            _logWriter.Close()


        End Sub

        ' end Close

    End Class

End Namespace