/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using System.Collections;
using Db4objects.Db4o.Types;
using Db4objects.Db4o.Internal;

namespace Db4objects.Db4o
{
	internal abstract class P1Collection : P1Object, IDb4oCollection, IDb4oTypeImpl
	{
		[NonSerialized]
		internal int i_activationDepth = -1;

		[NonSerialized]
		internal bool i_deleteRemoved;

		internal P1Collection()
			: base()
		{
		}

		public void ActivationDepth(int depth)
		{
			i_activationDepth = depth;
		}

		public void DeleteRemoved(bool flag)
		{
			i_deleteRemoved = flag;
		}

		public IEnumerator GetEnumerator()
		{
			// This is a bit of a mess, because IDictionary has
			// two GetEnumerator signatures.
			return GetEnumerator1();
		}

		protected abstract IEnumerator GetEnumerator1();

		internal int ElementActivationDepth()
		{
			return i_activationDepth - 1;
		}
	}
}