/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4objects.Db4o.Ext;
using Db4objects.Db4o.Internal.CS.Messages;
using Sharpen.Lang;

namespace Db4objects.Db4o.Internal.CS.Messages
{
	public class MProcessDeletes : Msg, IServerSideMessage
	{
		public bool ProcessAtServer()
		{
			lock (StreamLock())
			{
				try
				{
					Stream().WithTransaction(Transaction(), new _IRunnable_15(this));
				}
				catch (Db4oException e)
				{
				}
			}
			// Don't send the exception to the user because delete is asynchronous
			return true;
		}

		private sealed class _IRunnable_15 : IRunnable
		{
			public _IRunnable_15(MProcessDeletes _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				this._enclosing.Transaction().ProcessDeletes();
			}

			private readonly MProcessDeletes _enclosing;
		}
	}
}
