/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using Db4oUnit;
using System.Globalization;
using System.Threading;

class Foo
{
	public static void Bar()
	{
		throw new ApplicationException();
	}
}

public class PreserveDebugInfoSubject : ITestCase
{
	public void Test()
	{
        CultureInfo currentUICulture = Thread.CurrentThread.CurrentUICulture;
        try
        {
            Thread.CurrentThread.CurrentUICulture = CultureInfo.InvariantCulture;
            try
            {
                Foo.Bar();
            }
            catch (Exception x)
            {
                string message = x.ToString();
                Assert.IsTrue(message.Contains("PreserveDebugInfoSubject.cs:line 10"), message);
            }
        }
        finally
        {
            Thread.CurrentThread.CurrentUICulture = currentUICulture;
        }
	}
}