/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal
{
	/// <exclude></exclude>
	public class TransactionalReferenceSystem : Db4objects.Db4o.Internal.IReferenceSystem
	{
		internal readonly Db4objects.Db4o.Internal.IReferenceSystem _committedReferences = 
			new Db4objects.Db4o.Internal.HashcodeReferenceSystem();

		private Db4objects.Db4o.Internal.IReferenceSystem _newReferences;

		public TransactionalReferenceSystem()
		{
			CreateNewReferences();
		}

		public virtual void AddExistingReference(Db4objects.Db4o.Internal.ObjectReference
			 @ref)
		{
			_committedReferences.AddExistingReference(@ref);
		}

		public virtual void AddExistingReferenceToIdTree(Db4objects.Db4o.Internal.ObjectReference
			 @ref)
		{
			_committedReferences.AddExistingReferenceToIdTree(@ref);
		}

		public virtual void AddExistingReferenceToObjectTree(Db4objects.Db4o.Internal.ObjectReference
			 @ref)
		{
			_committedReferences.AddExistingReferenceToObjectTree(@ref);
		}

		public virtual void AddNewReference(Db4objects.Db4o.Internal.ObjectReference @ref
			)
		{
			_newReferences.AddNewReference(@ref);
		}

		public virtual void Commit()
		{
			_newReferences.TraverseReferences(new _AnonymousInnerClass38(this));
			CreateNewReferences();
		}

		private sealed class _AnonymousInnerClass38 : Db4objects.Db4o.Foundation.IVisitor4
		{
			public _AnonymousInnerClass38(TransactionalReferenceSystem _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Visit(object obj)
			{
				this._enclosing._committedReferences.AddExistingReference((Db4objects.Db4o.Internal.ObjectReference
					)obj);
			}

			private readonly TransactionalReferenceSystem _enclosing;
		}

		private void CreateNewReferences()
		{
			_newReferences = new Db4objects.Db4o.Internal.HashcodeReferenceSystem();
		}

		public virtual Db4objects.Db4o.Internal.ObjectReference ReferenceForId(int id)
		{
			Db4objects.Db4o.Internal.ObjectReference @ref = _newReferences.ReferenceForId(id);
			if (@ref != null)
			{
				return @ref;
			}
			return _committedReferences.ReferenceForId(id);
		}

		public virtual Db4objects.Db4o.Internal.ObjectReference ReferenceForObject(object
			 obj)
		{
			Db4objects.Db4o.Internal.ObjectReference @ref = _newReferences.ReferenceForObject
				(obj);
			if (@ref != null)
			{
				return @ref;
			}
			return _committedReferences.ReferenceForObject(obj);
		}

		public virtual void RemoveReference(Db4objects.Db4o.Internal.ObjectReference @ref
			)
		{
			_newReferences.RemoveReference(@ref);
			_committedReferences.RemoveReference(@ref);
		}

		public virtual void Rollback()
		{
			CreateNewReferences();
		}

		public virtual void TraverseReferences(Db4objects.Db4o.Foundation.IVisitor4 visitor
			)
		{
			_newReferences.TraverseReferences(visitor);
			_committedReferences.TraverseReferences(visitor);
		}
	}
}
