/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Replication
{
	/// <exclude></exclude>
	public class MigrationConnection
	{
		public readonly Db4objects.Db4o.Internal.ObjectContainerBase _peerA;

		public readonly Db4objects.Db4o.Internal.ObjectContainerBase _peerB;

		private readonly Db4objects.Db4o.Foundation.Hashtable4 _referenceMap;

		private readonly Db4objects.Db4o.Foundation.Hashtable4 _identityMap;

		public MigrationConnection(Db4objects.Db4o.Internal.ObjectContainerBase peerA, Db4objects.Db4o.Internal.ObjectContainerBase
			 peerB)
		{
			_referenceMap = new Db4objects.Db4o.Foundation.Hashtable4();
			_identityMap = new Db4objects.Db4o.Foundation.Hashtable4();
			_peerA = peerA;
			_peerB = peerB;
		}

		public virtual void MapReference(object obj, Db4objects.Db4o.Internal.ObjectReference
			 @ref)
		{
			_referenceMap.Put(Sharpen.Runtime.IdentityHashCode(obj), @ref);
		}

		public virtual void MapIdentity(object obj, object otherObj)
		{
			_identityMap.Put(Sharpen.Runtime.IdentityHashCode(obj), otherObj);
		}

		public virtual Db4objects.Db4o.Internal.ObjectReference ReferenceFor(object obj)
		{
			int hcode = Sharpen.Runtime.IdentityHashCode(obj);
			Db4objects.Db4o.Internal.ObjectReference @ref = (Db4objects.Db4o.Internal.ObjectReference
				)_referenceMap.Get(hcode);
			_referenceMap.Remove(hcode);
			return @ref;
		}

		public virtual object IdentityFor(object obj)
		{
			int hcode = Sharpen.Runtime.IdentityHashCode(obj);
			return _identityMap.Get(hcode);
		}

		public virtual void Terminate()
		{
			_peerA.MigrateFrom(null);
			_peerB.MigrateFrom(null);
		}

		public virtual Db4objects.Db4o.Internal.ObjectContainerBase Peer(Db4objects.Db4o.Internal.ObjectContainerBase
			 stream)
		{
			if (_peerA == stream)
			{
				return _peerB;
			}
			return _peerA;
		}
	}
}
