/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.IO
{
	/// <summary>IO adapter for random access files.</summary>
	/// <remarks>IO adapter for random access files.</remarks>
	public class RandomAccessFileAdapter : Db4objects.Db4o.IO.IoAdapter
	{
		private string _path;

		private Sharpen.IO.RandomAccessFile _delegate;

		public RandomAccessFileAdapter()
		{
		}

		protected RandomAccessFileAdapter(string path, bool lockFile, long initialLength)
		{
			_path = new Sharpen.IO.File(path).GetCanonicalPath();
			_delegate = new Sharpen.IO.RandomAccessFile(_path, "rw");
			if (initialLength > 0)
			{
				_delegate.Seek(initialLength - 1);
				_delegate.Write(new byte[] { 0 });
			}
			if (lockFile)
			{
				try
				{
					Db4objects.Db4o.Internal.Platform4.LockFile(_path, _delegate);
				}
				catch (Db4objects.Db4o.Ext.DatabaseFileLockedException e)
				{
					_delegate.Close();
					throw;
				}
			}
		}

		public override void Close()
		{
			try
			{
				Db4objects.Db4o.Internal.Platform4.UnlockFile(_path, _delegate);
			}
			catch
			{
			}
			_delegate.Close();
		}

		public override void Delete(string path)
		{
			new Sharpen.IO.File(path).Delete();
		}

		public override bool Exists(string path)
		{
			Sharpen.IO.File existingFile = new Sharpen.IO.File(path);
			return existingFile.Exists() && existingFile.Length() > 0;
		}

		public override long GetLength()
		{
			return _delegate.Length();
		}

		public override Db4objects.Db4o.IO.IoAdapter Open(string path, bool lockFile, long
			 initialLength)
		{
			return new Db4objects.Db4o.IO.RandomAccessFileAdapter(path, lockFile, initialLength
				);
		}

		public override int Read(byte[] bytes, int length)
		{
			return _delegate.Read(bytes, 0, length);
		}

		public override void Seek(long pos)
		{
			_delegate.Seek(pos);
		}

		public override void Sync()
		{
			_delegate.GetFD().Sync();
		}

		public override void Write(byte[] buffer, int length)
		{
			_delegate.Write(buffer, 0, length);
		}
	}
}
