/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Foundation
{
	/// <summary>Iterator primitives (concat, map, reduce, filter, etc...).</summary>
	/// <remarks>Iterator primitives (concat, map, reduce, filter, etc...).</remarks>
	/// <exclude></exclude>
	public class Iterators
	{
		internal static readonly object NO_ELEMENT = new object();

		public static System.Collections.IEnumerator Concat(System.Collections.IEnumerator
			 iterators)
		{
			return new Db4objects.Db4o.Foundation.CompositeIterator4(iterators);
		}

		public static System.Collections.IEnumerator Map(System.Collections.IEnumerator iterator
			, Db4objects.Db4o.Foundation.IFunction4 function)
		{
			return new Db4objects.Db4o.Foundation.FunctionApplicationIterator(iterator, function
				);
		}

		public static System.Collections.IEnumerator Map(object[] array, Db4objects.Db4o.Foundation.IFunction4
			 function)
		{
			return Map(new Db4objects.Db4o.Foundation.ArrayIterator4(array), function);
		}

		public static System.Collections.IEnumerator Filter(object[] array, Db4objects.Db4o.Foundation.IPredicate4
			 predicate)
		{
			return Filter(new Db4objects.Db4o.Foundation.ArrayIterator4(array), predicate);
		}

		public static System.Collections.IEnumerator Filter(System.Collections.IEnumerator
			 iterator, Db4objects.Db4o.Foundation.IPredicate4 predicate)
		{
			return new Db4objects.Db4o.Foundation.FilteredIterator(iterator, predicate);
		}
	}
}
