/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Querying
{
	public class ConjunctiveQbETestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public class Sup
		{
			public bool _flag;

			public Sup(bool flag)
			{
				this._flag = flag;
			}

			public virtual Db4objects.Db4o.IObjectSet Query(Db4objects.Db4o.IObjectContainer 
				db)
			{
				Db4objects.Db4o.Query.IQuery query = db.Query();
				query.Constrain(this);
				query.Descend("_flag").Constrain(true).Not();
				return query.Execute();
			}
		}

		public class Sub1 : Db4objects.Db4o.Tests.Common.Querying.ConjunctiveQbETestCase.Sup
		{
			public Sub1(bool flag) : base(flag)
			{
			}
		}

		public class Sub2 : Db4objects.Db4o.Tests.Common.Querying.ConjunctiveQbETestCase.Sup
		{
			public Sub2(bool flag) : base(flag)
			{
			}
		}

		protected override void Store()
		{
			Store(new Db4objects.Db4o.Tests.Common.Querying.ConjunctiveQbETestCase.Sub1(false
				));
			Store(new Db4objects.Db4o.Tests.Common.Querying.ConjunctiveQbETestCase.Sub1(true)
				);
			Store(new Db4objects.Db4o.Tests.Common.Querying.ConjunctiveQbETestCase.Sub2(false
				));
			Store(new Db4objects.Db4o.Tests.Common.Querying.ConjunctiveQbETestCase.Sub2(true)
				);
		}

		public virtual void TestAndedQbE()
		{
			Db4oUnit.Assert.AreEqual(1, new Db4objects.Db4o.Tests.Common.Querying.ConjunctiveQbETestCase.Sub1
				(false).Query(Db()).Size());
		}
	}
}
