/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Querying
{
	public class CascadeOnUpdate : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public class Atom
		{
			public Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate.Atom child;

			public string name;

			public Atom()
			{
			}

			public Atom(Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate.Atom child)
			{
				this.child = child;
			}

			public Atom(string name)
			{
				this.name = name;
			}

			public Atom(Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate.Atom child, string
				 name) : this(child)
			{
				this.name = name;
			}
		}

		public object child;

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration conf)
		{
			conf.ObjectClass(this).CascadeOnUpdate(true);
		}

		protected override void Store()
		{
			Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate cou = new Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate
				();
			cou.child = new Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate.Atom(new Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate.Atom
				("storedChild"), "stored");
			Db().Set(cou);
		}

		public virtual void Test()
		{
			Foreach(GetType(), new _AnonymousInnerClass48(this));
			Reopen();
			Foreach(GetType(), new _AnonymousInnerClass59(this));
		}

		private sealed class _AnonymousInnerClass48 : Db4objects.Db4o.Foundation.IVisitor4
		{
			public _AnonymousInnerClass48(CascadeOnUpdate _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Visit(object obj)
			{
				Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate cou = (Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate
					)obj;
				((Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate.Atom)cou.child).name = "updated";
				((Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate.Atom)cou.child).child.name
					 = "updated";
				this._enclosing.Db().Set(cou);
			}

			private readonly CascadeOnUpdate _enclosing;
		}

		private sealed class _AnonymousInnerClass59 : Db4objects.Db4o.Foundation.IVisitor4
		{
			public _AnonymousInnerClass59(CascadeOnUpdate _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Visit(object obj)
			{
				Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate cou = (Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate
					)obj;
				Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate.Atom atom = (Db4objects.Db4o.Tests.Common.Querying.CascadeOnUpdate.Atom
					)cou.child;
				Db4oUnit.Assert.AreEqual("updated", atom.name);
				Db4oUnit.Assert.AreNotEqual("updated", atom.child.name);
			}

			private readonly CascadeOnUpdate _enclosing;
		}
	}
}
