/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Handlers
{
	/// <exclude></exclude>
	public class DoubleHandlerTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		private Db4objects.Db4o.Internal.ITypeHandler4 _handler;

		protected override void Db4oSetupBeforeStore()
		{
			_handler = new Db4objects.Db4o.Internal.Handlers.DoubleHandler(Stream());
		}

		public virtual void TestMarshalling()
		{
			double expected = 1.1;
			Db4objects.Db4o.Internal.Buffer buffer = new Db4objects.Db4o.Internal.Buffer(_handler
				.LinkLength());
			_handler.WriteIndexEntry(buffer, expected);
			buffer.Seek(0);
			object actual = _handler.ReadIndexEntry(buffer);
			Db4oUnit.Assert.AreEqual(expected, actual);
		}

		public virtual void TestComparison()
		{
			AssertComparison(0, 1.1, 1.1);
			AssertComparison(1, 1.0, 1.1);
			AssertComparison(-1, 1.1, 0.5);
		}

		private void AssertComparison(int expected, double prepareWith, double compareTo)
		{
			_handler.PrepareComparison(prepareWith);
			double doubleCompareTo = compareTo;
			Db4oUnit.Assert.AreEqual(expected, _handler.CompareTo(doubleCompareTo));
			switch (expected)
			{
				case 0:
				{
					Db4oUnit.Assert.IsTrue(_handler.IsEqual(doubleCompareTo));
					Db4oUnit.Assert.IsFalse(_handler.IsGreater(doubleCompareTo));
					Db4oUnit.Assert.IsFalse(_handler.IsSmaller(doubleCompareTo));
					break;
				}

				case 1:
				{
					Db4oUnit.Assert.IsFalse(_handler.IsEqual(doubleCompareTo));
					Db4oUnit.Assert.IsTrue(_handler.IsGreater(doubleCompareTo));
					Db4oUnit.Assert.IsFalse(_handler.IsSmaller(doubleCompareTo));
					break;
				}

				case -1:
				{
					Db4oUnit.Assert.IsFalse(_handler.IsEqual(doubleCompareTo));
					Db4oUnit.Assert.IsFalse(_handler.IsGreater(doubleCompareTo));
					Db4oUnit.Assert.IsTrue(_handler.IsSmaller(doubleCompareTo));
					break;
				}
			}
		}
	}
}
