/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class CanUpdateFalseRefreshTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public class Item
		{
			public int _id;

			public string _name;

			public Item(int id, string name)
			{
				_id = id;
				_name = name;
			}

			public virtual bool ObjectCanUpdate(Db4objects.Db4o.IObjectContainer container)
			{
				return false;
			}
		}

		protected override void Store()
		{
			Store(new Db4objects.Db4o.Tests.Common.Assorted.CanUpdateFalseRefreshTestCase.Item
				(1, "one"));
		}

		public virtual void Test()
		{
			Db4objects.Db4o.Tests.Common.Assorted.CanUpdateFalseRefreshTestCase.Item item = (
				Db4objects.Db4o.Tests.Common.Assorted.CanUpdateFalseRefreshTestCase.Item)RetrieveOnlyInstance
				(typeof(Db4objects.Db4o.Tests.Common.Assorted.CanUpdateFalseRefreshTestCase.Item)
				);
			item._name = "two";
			Db().Set(item);
			Db4oUnit.Assert.AreEqual("two", item._name);
			Db().Refresh(item, 2);
			Db4oUnit.Assert.AreEqual("one", item._name);
		}

		public static void Main(string[] args)
		{
			new Db4objects.Db4o.Tests.Common.Assorted.CanUpdateFalseRefreshTestCase().RunSoloAndClientServer
				();
		}
	}
}
