/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4oUnit.Extensions.Fixtures
{
	public abstract class AbstractClientServerDb4oFixture : Db4oUnit.Extensions.Fixtures.AbstractDb4oFixture
	{
		protected static readonly string FILE = "Db4oClientServer.yap";

		protected static readonly string HOST = "localhost";

		protected const int PORT = unchecked((int)(0xdb40));

		protected static readonly string USERNAME = "db4o";

		protected static readonly string PASSWORD = USERNAME;

		private Db4objects.Db4o.IObjectServer _server;

		private readonly Sharpen.IO.File _yap;

		protected readonly int _port;

		public AbstractClientServerDb4oFixture(Db4oUnit.Extensions.Fixtures.IConfigurationSource
			 configSource, string fileName, int port) : base(configSource)
		{
			_yap = new Sharpen.IO.File(fileName);
			_port = port;
		}

		public AbstractClientServerDb4oFixture(Db4oUnit.Extensions.Fixtures.IConfigurationSource
			 configSource) : this(configSource, FILE, PORT)
		{
		}

		public override void Close()
		{
			_server.Close();
		}

		public override void Open()
		{
			_server = Db4objects.Db4o.Db4oFactory.OpenServer(Config(), _yap.GetAbsolutePath()
				, _port);
			_server.GrantAccess(USERNAME, PASSWORD);
		}

		public abstract override Db4objects.Db4o.Ext.IExtObjectContainer Db();

		protected override void DoClean()
		{
			_yap.Delete();
		}

		public virtual Db4objects.Db4o.IObjectServer Server()
		{
			return _server;
		}

		public override Db4objects.Db4o.Internal.LocalObjectContainer FileSession()
		{
			return (Db4objects.Db4o.Internal.LocalObjectContainer)_server.Ext().ObjectContainer
				();
		}

		public override void Defragment()
		{
			Defragment(FILE);
		}

		protected virtual Db4objects.Db4o.IObjectContainer OpenEmbeddedClient()
		{
			return _server.OpenClient(Config());
		}
	}
}
