/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
using System;
using System.IO;

using Db4objects.Db4o.Query;
using Db4objects.Db4o.Tutorial;

namespace Db4objects.Db4o.Tutorial.F1.Chapter1
{
	public class FirstStepsExample : Util
	{    
		public static void Main(string[] args)
		{
			File.Delete(Util.YapFileName);
			AccessDb4o();
			File.Delete(Util.YapFileName);
			IObjectContainer db = Db4oFactory.OpenFile(Util.YapFileName);
			try
			{
				StoreFirstPilot(db);
				StoreSecondPilot(db);
				RetrieveAllPilots(db);
				RetrievePilotByName(db);
				RetrievePilotByExactPoints(db);
				UpdatePilot(db);
				DeleteFirstPilotByName(db);
				DeleteSecondPilotByName(db);
			}
			finally
			{
				db.Close();
			}
		}
        
		public static void AccessDb4o()
		{
			IObjectContainer db = Db4oFactory.OpenFile(Util.YapFileName);
			try
			{
				// do something with db4o
			}
			finally
			{
				db.Close();
			}
		}
        
		public static void StoreFirstPilot(IObjectContainer db)
		{
			Pilot pilot1 = new Pilot("Michael Schumacher", 100);
			db.Set(pilot1);
			Console.WriteLine("Stored {0}", pilot1);
		}
    
		public static void StoreSecondPilot(IObjectContainer db)
		{
			Pilot pilot2 = new Pilot("Rubens Barrichello", 99);
			db.Set(pilot2);
			Console.WriteLine("Stored {0}", pilot2);
		}
    
		public static void RetrieveAllPilotQBE(IObjectContainer db) 
		{
			Pilot proto = new Pilot(null, 0);
			IObjectSet result = db.Get(proto);
			ListResult(result);
		}
    
		public static void RetrieveAllPilots(IObjectContainer db) 
		{
			IObjectSet result = db.Get(typeof(Pilot));
			ListResult(result);
		}
    
		public static void RetrievePilotByName(IObjectContainer db)
		{
			Pilot proto = new Pilot("Michael Schumacher", 0);
			IObjectSet result = db.Get(proto);
			ListResult(result);
		}
        
		public static void RetrievePilotByExactPoints(IObjectContainer db)
		{
			Pilot proto = new Pilot(null, 100);
			IObjectSet result = db.Get(proto);
			ListResult(result);
		}
    
		public static void UpdatePilot(IObjectContainer db)
		{
			IObjectSet result = db.Get(new Pilot("Michael Schumacher", 0));
			Pilot found = (Pilot)result.Next();
			found.AddPoints(11);
			db.Set(found);
			Console.WriteLine("Added 11 points for {0}", found);
			RetrieveAllPilots(db);
		}
    
		public static void DeleteFirstPilotByName(IObjectContainer db)
		{
			IObjectSet result = db.Get(new Pilot("Michael Schumacher", 0));
			Pilot found = (Pilot)result.Next();
			db.Delete(found);
			Console.WriteLine("Deleted {0}", found);
			RetrieveAllPilots(db);
		}
    
		public static void DeleteSecondPilotByName(IObjectContainer db)
		{
			IObjectSet result = db.Get(new Pilot("Rubens Barrichello", 0));
			Pilot found = (Pilot)result.Next();
			db.Delete(found);
			Console.WriteLine("Deleted {0}", found);
			RetrieveAllPilots(db);
		}
	}
}
