/* 
** Write debugging information into log-file.
**
** This library and program is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**   
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the Free
** Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
** MA 02111-1307, USA
*/

#ifndef __DAV_DEBUG_H__
#define __DAV_DEBUG_H__


#ifdef DEBUG

#define DBG0(x)   syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_DEBUG), x)
#define DBG1(x, a1)   syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_DEBUG), x, a1)
#define DBG2(x, a1, a2)   syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_DEBUG), x, a1, a2)

#define DBG_ARGS do { \
    DBG0("  Arguments after parsing config files:"); \
    DBG1("    dav_user = %s", args->dav_user); \
    DBG1("    dav_group = %s", args->dav_group); \
    DBG1("    ignore_home = %s", args->ignore_home); \
    DBG1("    conf = %s", args->conf); \
    DBG1("    user = %i", args->user); \
    DBG1("    netdev = %i", args->netdev); \
    DBG1("    mopts = %#lx", args->mopts); \
    DBG1("    add_mopts = %s", args->add_mopts); \
    DBG1("    kernel_fs = %s", args->kernel_fs); \
    DBG1("    buf_size = %i KiBytes", args->buf_size); \
    DBG1("    uid = %i", args->uid); \
    DBG1("    gid = %i", args->gid); \
    DBG1("    dir_umask = %#o", args->dir_umask); \
    DBG1("    file_umask = %#o", args->file_umask); \
    DBG1("    dir_mode = %#o", args->dir_mode); \
    DBG1("    file_mode = %#o", args->file_mode); \
    DBG1("    scheme = %s", args->scheme); \
    DBG1("    host = %s", args->host); \
    DBG1("    port = %i", args->port); \
    DBG1("    path = %s", args->path); \
    DBG1("    servercert = %s", args->servercert); \
    DBG1("    secrets = %s", args->secrets); \
    DBG1("    clicert = %s", args->clicert); \
    DBG1("    p_host = %s", args->p_host); \
    DBG1("    p_port = %i", args->p_port); \
    DBG1("    useproxy = %i", args->useproxy); \
    DBG1("    askauth = %i", args->askauth); \
    DBG1("    displayname = %i", args->displayname); \
    DBG1("    locks = %i", args->locks); \
    DBG1("    expect100 = %i", args->expect100); \
    DBG1("    read_timeout = %li s", args->read_timeout); \
    DBG1("    server_charset = %s", args->s_charset); \
    DBG1("    sys_cache = %s", args->sys_cache); \
    DBG1("    cache_dir = %s", args->cache_dir); \
    DBG1("    backup_dir = %s", args->backup_dir); \
    DBG1("    cache_size = %i MiByte", args->cache_size); \
    DBG1("    table_size = %i", args->table_size); \
    DBG1("    idle_time = %li s", args->idle_time); \
    DBG1("    dir_refresh = %li s", args->dir_refresh); \
    DBG1("    file_refresh = %li s", args->file_refresh); \
    DBG1("    gui_optimize = %i", args->gui_optimize); \
    DBG1("    retry = %li s", args->retry); \
    DBG1("    max_retry = %li s", args->max_retry); \
    DBG1("    lock_timeout = %li s", args->lock_timeout); \
    DBG1("    lock_refresh = %li s", args->lock_refresh); \
    DBG1("    lock_owner = %s", args->lock_owner); \
} while (0)

#define DBG_CMDLINE(x) do { \
    size_t len; \
    char * cmdline; \
    if (argz_create(x, &cmdline, &len) == 0) { \
        argz_stringify(cmdline, len, ' '); \
        DBG1("  %s", cmdline); \
        free(cmdline); \
        cmdline = NULL; \
    } \
} while (0)

#define DBG_RET(x) do { \
    switch(x) { \
    case 0: \
        DBG1("  return: %s", "OK"); \
        break; \
    case 1: \
        DBG1("  return: %s", "EPERM"); \
        break; \
    case 2: \
        DBG1("  return: %s", "ENOENT"); \
        break; \
    case 5: \
        DBG1("  return: %s", "EIO"); \
        break; \
    case 9: \
        DBG1("  return: %s", "EBADF"); \
        break; \
    case 11: \
        DBG1("  return: %s", "EAGAIN"); \
        break; \
    case 13: \
        DBG1("  return: %s", "EACCES"); \
        break; \
    case 16: \
        DBG1("  return: %s", "EBUSY"); \
        break; \
    case 17: \
        DBG1("  return: %s", "EEXIST"); \
        break; \
    case 20: \
        DBG1("  return: %s", "ENOTDIR"); \
        break; \
    case 21: \
        DBG1("  return: %s", "EISDIR"); \
        break; \
    case 22: \
        DBG1("  return: %s", "EINVAL"); \
        break; \
    case 28: \
        DBG1("  return: %s", "ENOSPC"); \
        break; \
    case 30: \
        DBG1("  return: %s", "EROFS"); \
        break; \
    case 39: \
        DBG1("  return: %s", "ENOTEMPTY"); \
        break; \
    case 95: \
        DBG1("  return: %s", "ENOTSUP"); \
        break; \
    default: \
        DBG1("  return: %i", x); \
    } \
} while (0)

#else /* DEBUG */

#define DBG0(x) 
#define DBG1(x, a1)
#define DBG2(x, a1, a2)
#define DBG_ARGS
#define DBG_CMDLINE(x)
#define DBG_RET(x)

#endif /* DEBUG */


#ifdef DEBUG_SECRETS
#define DBG_SECRETS do { \
    DBG0("  Credentials:"); \
    DBG1("    username = %s", args->username); \
    DBG1("    passord = %s", args->password); \
    DBG1("    p_user = %s", args->p_user); \
    DBG1("    p_passord = %s", args->p_passwd); \
} while (0)
#else /* DEBUG_SECRETS */
#define DBG_SECRETS
#endif /* DEBUG_SECRETS */


#endif
