dnl
dnl davfs2 macros
dnl


AC_DEFUN([DAV_CHECK_NEON],[

    AC_ARG_WITH(neon,
      [  --with-neon[[=DIR]]       specify location of neon library],
      [case $withval in
          yes|no) neon_ext_path= ;;
          *) neon_ext_path=$withval ;;
      esac;],
      [neon_ext_path=]
    )

    neon_got_library=no
    if test "x$neon_ext_path" = "x"; then
        AC_PATH_PROG([NEON_CONFIG], neon-config, none)
        if test "x${NEON_CONFIG}" = "xnone"; then
            AC_MSG_NOTICE([no external neon library found])
        elif test -x "${NEON_CONFIG}"; then
            NEON_USE_EXTERNAL
        else
            AC_MSG_NOTICE([ignoring non-executable ${NEON_CONFIG}])
        fi
    else
        AC_MSG_CHECKING([for neon library in $neon_ext_path])
        NEON_CONFIG="$neon_ext_path/bin/neon-config"
        if test -x ${NEON_CONFIG}; then
            AC_MSG_RESULT([found])
            NEON_USE_EXTERNAL
        else
            AC_MSG_RESULT([not found])
        fi
    fi

    if test "$neon_got_library" = "no"; then 
        AC_MSG_ERROR(could not find neon)
    fi

    AC_SUBST(NEON_LIBS)
])


AC_DEFUN([DAV_DEFAULTS],[

    AC_ARG_VAR([dav_user],
        [if invoked by root, mount.davfs runs as this user [davfs2]])
    if test -z "$dav_user"; then dav_user="davfs2"; fi

    AC_ARG_VAR([dav_group],
        [the group, the mount.davfs daemon belongs to [davfs2]])
    if test -z "$dav_group"; then dav_group="davfs2"; fi

    AC_ARG_VAR([dav_localstatedir],
        [directory to store pid-files in [/var/run]])
    if test -z "$dav_localstatedir"; then dav_localstatedir="/var/run"; fi

    AC_ARG_VAR([dav_syscachedir],
        [cache directory [/var/cache]])
    if test -z "$dav_syscachedir"; then dav_syscachedir="/var/cache"; fi
])


AC_DEFUN([DAV_DEBUG],[

    AC_ARG_ENABLE(debug,
        [  --enable-debug          enable debug output, don't display credentials
  --enable-debug=secrets  enable debug output including credentials],
        [dav_debug="${enableval}"], [dav_debug="no"]
    )

    if test "$dav_debug" = "yes" -o "$dav_debug" = "secrets" ; then
        AC_DEFINE_UNQUOTED(DEBUG, 1, [Enable debug output, but not credentials.])
        CPPFLAGS="-g $CPPFLAGS"
    fi

    if test "$dav_debug" = "secrets"; then
        AC_DEFINE_UNQUOTED(DEBUG_SECRETS, 1, [Show credentials in debug output too.])
    fi
])


AC_DEFUN([DAV_LINGUAS],[

    AC_ARG_VAR([LINGUAS],
        [select languages for messages and documentation])
    dav_desired_linguas="${LINGUAS-%UNSET%}"

    dav_all_linguas=
    if test -f "man/po4a.conf"; then
        dav_all_linguas="`cat 'man/po4a.conf' | grep '[po4a_langs]' | sed 's/.po4a_langs.//'`" 
    fi

    dav_linguas=
    if test "$dav_desired_linguas" == "%UNSET%"; then
        dav_linguas="$dav_all_linguas"
    else
        for dav_lingua in $dav_desired_linguas; do
            case "$dav_all_linguas" in
                *"$dav_lingua"*) dav_linguas="$dav_linguas $dav_lingua";;
            esac
        done
    fi

    AC_SUBST([dav_linguas])
])


AC_DEFUN([DAV_LFS],[

    if test "$ne_LFS_message" = "LFS is supported by neon"; then
        AC_SYS_LARGEFILE
    fi

    if test "$ac_cv_sys_file_offset_bits" = "64"; then
        dav_lfs=yes
    else
        dav_lfs=no
    fi
])


AC_DEFUN([DAV_MESSAGE],[

    if test "$USE_NLS" = "yes"; then
        dav_nls=${gt_source}
    else
        dav_nls=no
    fi

cat<<EOF

Configuration for building davfs2 AC_PACKAGE_VERSION:

  Install Prefix:            ${prefix}
  Compiler:                  ${CC}
  Large File Support:        ${dav_lfs}
  Neon Library:              ${neon_library_message}
                             ${ne_SSL_message}
  National Language Support: ${dav_nls}

EOF
])
