/* 
** DAV and CODA  connection, request and response process
**
** This library and program is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**   
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the Free
** Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
** MA 02111-1307, USA
*/

#ifndef __DAVFSD_H__
#define __DAVFSD_H__

#include "config.h"
#include <sys/types.h>

/* Linux Kernel Source */
/* avoid inclusion of kernel time.h, since it conflicts with userland time.h */
#define _LINUX_TIME_H
/* This macro is used in coda.h and causes compile errors.
   We don't need it and define it as empty. */
#define __user
#include <linux/coda.h>

#ifndef DIRBLKSIZ
#define DIRBLKSIZ 0x200
#endif

#define VFS_STANDALONE 1

/* some platforms using gcc do not define this (BAD) */
#ifndef PATH_MAX
#define PATH_MAX  1024        /* max # of characters in a path name on Solaris */
#endif

#define PARANOIA 1

#define SELECT_TIME_OUT 15

#if CODA_KERNEL_VERSION > 2
#if SIZEOF_VOID_P > SIZEOF_U_INT32_T * 2
#error "davfs2 cannot be built with this version of CODA."
#endif /* size check */
typedef struct _DAVCodaFid {
    u_int32_t Volume;
    u_int32_t Vnode;
    union {
        struct v_list *List; /* this member may be 64bit wide */
        u_int32_t make_the_union_64_bit_wide[2];
    };
} DAVCodaFid;
#else /* CODA_KERNEL_VERSION */
#if SIZEOF_VOID_P > SIZEOF_U_LONG
#error "davfs2 cannot be built with this version of CODA."
#endif /* size check */
typedef struct _DAVCodaFid {
    u_long Volume;
    u_long Vnode;
    union {
        struct v_list *List; /* this member must not be longer than u_long */
        u_long make_the_union_as_long_as_u_long;
    };
} DAVCodaFid;
#endif /* CODA_KERNEL_VERSION */

/* There is nothing magic about these constants. I just selected them
 * so that kernel does not complain too loudly.  */
#define MY_VOL   0x01234567
#define MY_VNODE 0xffffffff
#define MY_INODE 0x12348765

#define SIZEOF_INBUF (sizeof(union inputArgs) + 1024 + CODA_MAXNAMLEN)
#define SIZEOF_OUTBUF (sizeof(union outputArgs) + 1024 + CODA_MAXNAMLEN)


#define CMD(x) do { \
    out_buf->oh.result = 0; \
    size = sizeof(out_buf->coda_##x); \
    DBG1( "%.10s\n",#x ); \
} while (0)
#define CMD_NOREP(x) do { \
    out_buf->oh.result = 0; \
    DBG1( "%.10s",#x ); \
} while (0)
#define STAT(x) { \
    if (dav_stat_cache(x, &st, prev_list_result, prev_base_dir) == -1 && dav_stat(x, &st, is_dir, 0) == -1) { \
    out_buf->oh.result = dav_get_errno(); \
    DBG1( "file '%s' probably does not exist.", (x) ); \
    break; \
    } \
}
#define DUMP(x) DBG1( "  base:%s", look_name((DAVCodaFid* )&in_buf->coda_##x.VFid, &is_dir));
#define DUMP_NAME(x) DBG2( "\tbase:%s\tname:%s\n\t", look_name((DAVCodaFid *)&in_buf->coda_##x.VFid, &is_dir), (char*)in_buf + in_buf->coda_##x.name);
#define BUILD_NAME(x) do { \
    name = ((char*) in_buf) + in_buf->coda_##x.name; \
    snprintf((buf), sizeof(buf), "%s/%s", \
     look_name((DAVCodaFid *)&in_buf->coda_##x.VFid, &is_dir), name); \
} while (0)
#define GET_VFID_name(x) \
    if (NULL == (name = look_name((DAVCodaFid *)&in_buf->coda_##x.VFid, &is_dir))) { \
    out_buf->oh.result = ENOENT; \
    break; \
    }

/* our local object: NOTE: we try to do as little as possible
 * and trust that vfs will handle caching for us */
struct v_list
{
    char *real_name;
    char *local_name;
    short usage;
    unsigned char has_changed: 1;        // dirty bit
    unsigned char is_dir: 1;
    unsigned char is_created: 1;        // marker for files which do not yet exist at the other end
    unsigned char is_trunc: 1;        // marker for files which are to be sent to the other end
    /* timestamp ?? */
};

/* Linked list structure */
typedef struct davfs_list {
    void *data;
    struct davfs_list *next;
} davfs_list;    

#define v_usage(x) ((DAVCodaFid *)&(x))->List->usage
#define v_created(x) ((DAVCodaFid *)&(x))->List->is_created

#endif

/* start emacs stuff */
/* 
 * local variables: 
 * eval: (load-file "../tools/davfs-emacs.el") 
 * end: 
 */ 

