;;; davfs2 C style conventions for Emacs
;
; Add the folowing block to the end of source files:
;
;/* 
; * local variables: 
; * eval: (load-file "davfs-emacs.el") 
; * end: 
; */ 
;
;
; Notes:
;  http://httpd.apache.org/dev/styleguide.html
;  indent -i4 -npsl -di0 -br -nce -d0 -cli0 -npcs -nfc1 -nut
;  http://www.jwz.org/doc/tabs-vs-spaces.html
;
; For vim, we'd want:
;   /* ex: set tabstop=4 softtabstop=2 shiftwidth=4 expandtab: */
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(if (eq major-mode 'c-mode) 
    (progn 
      (c-add-style "davfs" 
		   '("gnu" (c-offsets-alist . ((inextern-lang . 0)))))
  (c-set-style "davfs")))

(setq c-basic-indent   4	; - press tab to align to mod-N
      tab-width        4	; - interpret a physical tab as this wide
      indent-tabs-mode nil	; - don't compress spaces to tabs
) 

; We don't have an angry mob (yet), so we don't need this.  
;(setq angry-mob-with-torches-and-pitchforks t) 

