.\" DO NOT MODIFY THIS FILE!  It was generated by help2man 1.40.4.
.TH DGREP "1" "January 2014" "dateutils 0.2.7" "User Commands"
.SH NAME
dgrep - Find date or time matches in input stream
.SH SYNOPSIS
.B dgrep
[\fIOPTION\fR]... \fIEXPRESSION\fR
.SH DESCRIPTION
dgrep 0.2.7
.PP
Grep standard input for lines that match EXPRESSION.
.PP
EXPRESSION may be date/times prefixed with an operator `<', `<=', '=', '>=',
\&'>', `!=', `<>' (if omitted defaults to `='),
which will match lines with date/times which are older, older\-equal, equal,
newer\-equal, newer, or not equal respectively.
.PP
EXPRESSION may also be format specifiers infixed by above operators
and suffixed by a value (e.g. `%a="Wed"') which matches lines whose
%a representation (weekday name abbreviated) is "Wed".
.PP
EXPRESSION may be statements as described above concatenated through `&&' (for
conjunction) or `||' (disjunction), both of which may be parenthesised as per
usual to change precedence (`&&' goes over `||').
.PP
If multiple date/times occur on the same line and any one of them fulfills the
criteria then the line is considered a match and will be output.
.TP
\fB\-h\fR, \fB\-\-help\fR
Print help and exit
.TP
\fB\-V\fR, \fB\-\-version\fR
Print version and exit
.TP
\fB\-q\fR, \fB\-\-quiet\fR
Suppress message about date/time and duration
parser errors.
.TP
\fB\-i\fR, \fB\-\-input\-format\fR=\fISTRING\fR
Input format, can be used multiple times.
Each date/time will be passed to the input
format parsers in the order they are given, if a
date/time can be read successfully with a given
input format specifier string, that value will
be used.
.TP
\fB\-e\fR, \fB\-\-backslash\-escapes\fR
Enable interpretation of backslash escapes in the
output and input format specifier strings.
.TP
\fB\-o\fR, \fB\-\-only\-matching\fR
Show only the part of a line matching DATE.
.TP
\fB\-v\fR, \fB\-\-invert\-match\fR
Select non\-matching lines.
.IP
Group: op
.IP
Operations can be specified by options as well.
EXPRESSION must then be a date/time and no concatenation through
conjunction (`&&') or disjunction (`||') operators is possible.
.IP
This serves solely as a means of convenience, e.g. the dtest tool has a
similar syntax.
.TP
\fB\-\-eq\fR
Lines match when date/times are equal to
EXPRESSION.
.TP
\fB\-\-ne\fR
Lines match when date/times are not the same as
EXPRESSION.
.TP
\fB\-\-gt\fR
Lines match when date/times are newer than
EXPRESSION.
.TP
\fB\-\-lt\fR
Lines match when date/times are older than
EXPRESSION.
.TP
\fB\-\-ge\fR
Lines match when date/times are newer than or
equal EXPRESSION.
.TP
\fB\-\-le\fR
Lines match when date/times are older than or
equal EXPRESSION.
.TP
\fB\-\-nt\fR
Lines match when date/times are newer than or
equal EXPRESSION.
.TP
\fB\-\-ot\fR
Lines match when date/times are older than or
equal EXPRESSION.
.SH EXAMPLES

  $ dgrep 2012-03-01 <<EOF
  2012-02-28
  2012-02-29
  2012-03-01
  2012-03-02
  EOF
  2012-03-01
  $


  $ dgrep '<2012-03-01' <<EOF
  2012-02-28
  2012-02-29
  2012-03-01
  2012-03-02
  EOF
  2012-02-28
  2012-02-29
  $


  $ dgrep \!=2012-03-01 <<EOF
  2012-02-28
  2012-02-29
  2012-03-01
  2012-03-02
  EOF
  2012-02-28
  2012-02-29
  2012-03-02
  $


  $ dgrep =2012-03-01 <<EOF
  Feb	2012-02-28
  Feb	2012-02-29	leap day
  Mar	2012-03-01
  Mar	2012-03-02
  EOF
  Mar	2012-03-01
  $


  $ dgrep -o \<2012-03-01 <<EOF
  Feb	2012-02-28
  Feb	2012-02-29	leap day
  Mar	2012-03-01
  Mar	2012-03-02
  EOF
  2012-02-28
  2012-02-29
  $


  $ dgrep '>=12:00:00' <<EOF
  fileA	11:59:58
  fileB	11:59:59	leap second?
  fileNOON	12:00:00	new version
  fileC	12:03:12
  EOF
  fileNOON	12:00:00	new version
  fileC	12:03:12
  $


  $ dgrep -o '>=12:00:00' <<EOF
  fileA	11:59:58
  fileB	11:59:59	leap second?
  fileNOON	12:00:00	new version
  fileC	12:03:12
  EOF
  12:00:00
  12:03:12
  $


  $ dgrep 2012-03-01 <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-03-01T10:00:00
  $


  $ dgrep '<2012-03-01' <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  $


  $ dgrep 2012-03-01T10:00:00 <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-03-01T10:00:00
  $


  $ dgrep '<2012-03-01T14:00:00' <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  $
.SH AUTHOR
Written by Sebastian Freundt <freundt@fresse.org>
.SH "REPORTING BUGS"
Report bugs to: https://github.com/hroptatyr/dateutils/issues
.SH "SEE ALSO"
The full documentation for
.B dgrep
is maintained as a Texinfo manual.  If the
.B info
and
.B dgrep
programs are properly installed at your site, the command
.IP
.B info (dateutils)dgrep
.PP
should give you access to the complete manual.
